/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.tailscale;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.HostAddressSwitchStore;
import io.xpipe.app.ext.LocalStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LocalShell;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableBiFunction;
import io.xpipe.core.FailableConsumer;
import io.xpipe.core.FailableSupplier;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.s;
import io.xpipe.ext.proc.ssh.t;
import io.xpipe.ext.proc.tailscale.g;
import io.xpipe.ext.proc.tunnel.c;
import io.xpipe.ext.proc.tunnel.j;
import io.xpipe.ext.proc.tunnel.k;
import io.xpipe.ext.proc.tunnel.m;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="tailscaleDevice")
@JsonDeserialize(builder=c.class)
public final class b
implements FixedChildStore,
HostAddressSwitchStore,
NameableStore,
NetworkTunnelStore,
SelfReferentialStore,
ShellStore,
StatefulDataStore<a>,
j {
    private final DataStoreEntryRef<g> tailnet;
    private final String id;
    private final HostAddress hostName;
    private final IdentityValue identity;

    public final void checkComplete() {
        Validators.nonNull(this.tailnet);
        Validators.isType(this.tailnet, g.class);
        this.tailnet.checkComplete();
        Validators.nonNull((Object)this.id);
        Validators.nonNull((Object)this.hostName);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(this){
            private /* synthetic */ b eE;
            {
                this.eE = b2;
            }

            public final ShellControl control(ShellControl shellControl2) {
                ((g)this.eE.getTailnet().getStore()).checkLicenseOrThrow();
                Object object = new io.xpipe.ext.proc.tailscale.a(LocalShell.getShell());
                if (!((io.xpipe.ext.proc.tailscale.a)((Object)object)).aM(((g)this.eE.getTailnet().getStore()).getAccount())) {
                    throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Tailscale login is needed"));
                }
                ((g)this.eE.getTailnet().getStore()).updateActiveState();
                object = ((io.xpipe.ext.proc.tailscale.a)((Object)object)).a(this.eE);
                if (((Optional)object).isEmpty()) {
                    throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Tailscale device has been removed from the tailnet."));
                }
                this.eE.setState((DataStoreState)((a)this.eE.getState()).mergeCopy((DataStoreState)((Optional)object).get()));
                if (!Boolean.TRUE.equals(((a)this.eE.getState()).getOnline())) {
                    throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Tailscale device is not online. The device needs to be running and added to the tailnet."));
                }
                if (!Boolean.TRUE.equals(((a)this.eE.getState()).getSsh())) {
                    object = new IllegalStateException("Tailscale SSH is not enabled for this device. The device needs to be added to the tailnet with \"tailscale up --ssh\".");
                    ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)object).expected().link("https://tailscale.com/kb/1193/tailscale-ssh"));
                    throw object;
                }
                object = this.eE.buildShellControlConfig();
                shellControl2 = s.a(shellControl2, (t)object);
                shellControl2.onInit((FailableConsumer<ShellControl, Exception>)((FailableConsumer)shellControl -> this.eE.setState((DataStoreState)((a.a)((Object)((Object)((a.a)((Object)((Object)((a)this.eE.getState()).toBuilder().online(Boolean.TRUE)))).ssh(Boolean.TRUE)))).build())));
                return shellControl2;
            }

            public final ShellStore getParentStore() {
                return new LocalStore();
            }
        };
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.id));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (b)fixedChildStore;
        return ((b)((b)this.toBuilder().hostName(fixedChildStore.hostName)).identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    public final DataStoreEntryRef<?> getNetworkParent() {
        return DataStorage.get().local().ref();
    }

    @Override
    public final String getTunnelHostName() {
        return this.getName();
    }

    public final NetworkTunnelSession createTunnelSession(int n2, int n3, String string) {
        return this.createTunnelSession(((c.a)((c.a)((c.a)io.xpipe.ext.proc.tunnel.c.builder().originPort(n2)).remotePort(n3)).remoteAddress(string)).build());
    }

    private t buildShellControlConfig() {
        t t2 = t.cs().baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(string, bl) -> {
            string = CommandBuilder.of().addQuoted(this.identity.unwrap().getUsername().retrieveUsername() + "@" + this.hostName.get()).add(new String[]{"-p", "22"});
            return string;
        })).displayHostName(this.hostName.get()).password((SecretRetrievalStrategy)(this.identity.unwrap().getPassword() != null ? this.identity.unwrap().getPassword() : new SecretRetrievalStrategy.None())).identity((SshIdentityStrategy)new NoneStrategy()).checkLocalhostKey(false).forwardX11(false).noInteraction(false).additionalOptions(null).secretId(() -> this.getSelfEntry().getUuid()).sourceStore(this).build();
        return t2;
    }

    public final String getName() {
        return (String)this.hostName.getAvailable().getFirst();
    }

    @Override
    public final m createTunnelSession(k k2) {
        FailableSupplier failableSupplier = () -> {
            k2 = this.buildShellControlConfig().ct().tunnelArguments(((k)k2).toTunnelArguments()).build();
            return s.a(ProcessControlProvider.get().createLocalProcessControl(true), (t)((Object)k2));
        };
        return m.a(k2, (FailableSupplier<ShellControl>)failableSupplier);
    }

    public final HostAddress getHostAddress() {
        return this.hostName;
    }

    public final Optional<HostAddressSwitchStore> withAddress(String string) {
        return Optional.ofNullable(((b)this.toBuilder().hostName(this.hostName.withValue(string))).build());
    }

    @Generated
    protected b(b<?, ?> b2) {
        this.tailnet = b2.tailnet;
        this.id = b2.id;
        this.hostName = b2.hostName;
        this.identity = b2.identity;
    }

    @Generated
    public static b<?, ?> builder() {
        return new c();
    }

    @Generated
    public final b<?, ?> toBuilder() {
        return new c().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<g> getTailnet() {
        return this.tailnet;
    }

    @Generated
    public final String getId() {
        return this.id;
    }

    @Generated
    public final HostAddress getHostName() {
        return this.hostName;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof b)) {
            return false;
        }
        object = (b)object;
        Object object2 = this.getTailnet();
        HostAddress hostAddress = ((b)object).getTailnet();
        if (object2 == null ? hostAddress != null : !object2.equals(hostAddress)) {
            return false;
        }
        object2 = this.getId();
        hostAddress = ((b)object).getId();
        if (object2 == null ? hostAddress != null : !object2.equals(hostAddress)) {
            return false;
        }
        object2 = this.getHostName();
        hostAddress = ((b)object).getHostName();
        if (object2 == null ? hostAddress != null : !object2.equals(hostAddress)) {
            return false;
        }
        object2 = this.getIdentity();
        object = ((b)object).getIdentity();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<g> dataStoreEntryRef = this.getTailnet();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        String string = this.getId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        string = this.getHostName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        string = this.getIdentity();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "TailscaleDeviceStore(tailnet=" + String.valueOf(this.getTailnet()) + ", id=" + this.getId() + ", hostName=" + String.valueOf(this.getHostName()) + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class b<C extends b, B extends b<C, B>> {
        @Generated
        private DataStoreEntryRef<g> tailnet;
        @Generated
        private String id;
        @Generated
        private HostAddress hostName;
        @Generated
        private IdentityValue identity;

        @Generated
        protected B $fillValuesFrom(C c2) {
            b.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(b b2, b<?, ?> b3) {
            b3.tailnet(b2.tailnet);
            b3.id(b2.id);
            b3.hostName(b2.hostName);
            b3.identity(b2.identity);
        }

        @Generated
        public B tailnet(DataStoreEntryRef<g> dataStoreEntryRef) {
            this.tailnet = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B id(String string) {
            this.id = string;
            return this.self();
        }

        @Generated
        public B hostName(HostAddress hostAddress) {
            this.hostName = hostAddress;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TailscaleDeviceStore.TailscaleDeviceStoreBuilder(tailnet=" + String.valueOf(this.tailnet) + ", id=" + this.id + ", hostName=" + String.valueOf(this.hostName) + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="tailscaleDevice")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class c
    extends b<b, c> {
        @Generated
        private c() {
        }

        @Override
        @Generated
        public final b build() {
            return new b(this);
        }
    }

    @JsonDeserialize(builder=b.class)
    public static class io.xpipe.ext.proc.tailscale.b$a
    extends ShellStoreState {
        private final Boolean ssh;
        private final Boolean online;
        private final Boolean exitNode;

        public io.xpipe.ext.proc.tailscale.b$a mergeCopy(DataStoreState object) {
            object = (io.xpipe.ext.proc.tailscale.b$a)((Object)object);
            ShellStoreState.ShellStoreStateBuilder shellStoreStateBuilder = this.toBuilder();
            this.mergeBuilder((io.xpipe.ext.proc.tailscale.b$a)((Object)object), (a<?, ?>)shellStoreStateBuilder);
            return shellStoreStateBuilder.build();
        }

        protected void mergeBuilder(io.xpipe.ext.proc.tailscale.b$a a2, a<?, ?> a3) {
            super.mergeBuilder((ShellStoreState)a2, a3);
            a3.online((Boolean)io.xpipe.ext.proc.tailscale.b$a.useNewer((Object)this.online, (Object)a2.online));
            a3.exitNode((Boolean)io.xpipe.ext.proc.tailscale.b$a.useNewer((Object)this.exitNode, (Object)a2.exitNode));
            a3.ssh((Boolean)io.xpipe.ext.proc.tailscale.b$a.useNewer((Object)this.ssh, (Object)a2.ssh));
        }

        @Generated
        protected io.xpipe.ext.proc.tailscale.b$a(a<?, ?> a2) {
            super(a2);
            this.ssh = a2.ssh;
            this.online = a2.online;
            this.exitNode = a2.exitNode;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Generated
        public a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public Boolean getSsh() {
            return this.ssh;
        }

        @Generated
        public Boolean getOnline() {
            return this.online;
        }

        @Generated
        public Boolean getExitNode() {
            return this.exitNode;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof io.xpipe.ext.proc.tailscale.b$a)) {
                return false;
            }
            Object object2 = (io.xpipe.ext.proc.tailscale.b$a)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            object = this.getSsh();
            Boolean bl = object2.getSsh();
            if (object == null ? bl != null : !object.equals(bl)) {
                return false;
            }
            object = this.getOnline();
            bl = object2.getOnline();
            if (object == null ? bl != null : !object.equals(bl)) {
                return false;
            }
            object = this.getExitNode();
            object2 = object2.getExitNode();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof io.xpipe.ext.proc.tailscale.b$a;
        }

        @Generated
        public int hashCode() {
            int n2 = super.hashCode();
            Boolean bl = this.getSsh();
            n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
            bl = this.getOnline();
            n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
            bl = this.getExitNode();
            n2 = n2 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends io.xpipe.ext.proc.tailscale.b$a, B extends a<C, B>>
        extends ShellStoreState.ShellStoreStateBuilder<C, B> {
            @Generated
            private Boolean ssh;
            @Generated
            private Boolean online;
            @Generated
            private Boolean exitNode;

            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(io.xpipe.ext.proc.tailscale.b$a a2, a<?, ?> a3) {
                a3.ssh(a2.ssh);
                a3.online(a2.online);
                a3.exitNode(a2.exitNode);
            }

            @Generated
            public B ssh(Boolean bl) {
                this.ssh = bl;
                return (B)this.self();
            }

            @Generated
            public B online(Boolean bl) {
                this.online = bl;
                return (B)this.self();
            }

            @Generated
            public B exitNode(Boolean bl) {
                this.exitNode = bl;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "TailscaleDeviceStore.State.StateBuilder(super=" + super.toString() + ", ssh=" + this.ssh + ", online=" + this.online + ", exitNode=" + this.exitNode + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<io.xpipe.ext.proc.tailscale.b$a, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final io.xpipe.ext.proc.tailscale.b$a build() {
                return new io.xpipe.ext.proc.tailscale.b$a(this);
            }
        }
    }
}

