/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.HostAddressSwitchStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.KeyValue;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.b;
import io.xpipe.ext.proc.ssh.d;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="ssh")
@JsonDeserialize(builder=b.class)
public final class u
extends io.xpipe.ext.proc.ssh.b<ShellStoreState>
implements HostAddressSwitchStore {
    private final DataStoreEntryRef<ShellStore> proxy;
    private final HostAddress host;
    private final Integer port;
    private final IdentityValue identity;
    private final Boolean dontInteractWithSystem;
    private final Boolean forwardX11;
    private final Boolean jumpServer;
    private final String additionalOptions;

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    public final void checkComplete() {
        Validators.nonNull(this.proxy);
        Validators.isType(this.proxy, ShellStore.class);
        Validators.nonNull((Object)this.host);
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
        this.identity.checkCompletePassword();
        this.identity.checkCompleteSshIdentity();
        this.proxy.checkComplete();
        d.aC(this.additionalOptions);
        this.checkValidGatewayChain();
    }

    public final boolean isPerUser() {
        return this.identity.isPerUser();
    }

    @Override
    public final d toConfigHost() {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        arrayList.add(new KeyValue("HostName", this.host.get()));
        arrayList.add(new KeyValue("Port", String.valueOf(this.port)));
        arrayList.add(new KeyValue("User", ((io.xpipe.ext.proc.ssh.b)this).getUser().retrieveUsername()));
        d d2 = this.getAdditionalOptions();
        if (d2 != null) {
            arrayList.addAll(d2.cd().cn());
        }
        return new d(new d.a(this.distinctConfigHostName(), arrayList));
    }

    @Override
    protected final boolean dontInteractWithSystem() {
        if (this.dontInteractWithSystem != null) {
            return this.dontInteractWithSystem;
        }
        return false;
    }

    @Override
    protected final boolean hasX11Forward() {
        return this.forwardX11 != null && this.forwardX11 != false;
    }

    @Override
    public final SecretRetrievalStrategy getPassword() {
        SecretRetrievalStrategy secretRetrievalStrategy = this.identity.unwrap().getPassword();
        if (secretRetrievalStrategy != null) {
            return secretRetrievalStrategy;
        }
        return new SecretRetrievalStrategy.None();
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getGateway() {
        return this.proxy;
    }

    @Override
    public final HostAddress getHostAddress() {
        return this.host;
    }

    @Override
    public final UsernameStrategy getUser() {
        return this.identity.unwrap().getUsername();
    }

    @Override
    public final int getPort() {
        if (this.port != null) {
            return this.port;
        }
        return 22;
    }

    @Override
    public final CommandBuilder buildBaseCommand() {
        CommandBuilder commandBuilder = CommandBuilder.of().addQuoted(((io.xpipe.ext.proc.ssh.b)this).getUser().retrieveUsername() + "@" + this.getEffectiveHostName()).add(new String[]{"-p", "" + this.getEffectivePort()});
        return commandBuilder;
    }

    @Override
    public final boolean isJumpServer() {
        return this.jumpServer != null && this.jumpServer != false;
    }

    @Override
    public final SshIdentityStrategy getIdentityStrategy() {
        SshIdentityStrategy sshIdentityStrategy = this.identity.unwrap().getSshIdentity();
        if (sshIdentityStrategy != null) {
            return sshIdentityStrategy;
        }
        return new NoneStrategy();
    }

    @Override
    protected final boolean hasTunnels() {
        return false;
    }

    @Override
    protected final d getAdditionalOptions() {
        if (this.additionalOptions != null) {
            d d2 = d.aC(this.additionalOptions);
            return d2;
        }
        return null;
    }

    public final Optional<HostAddressSwitchStore> withAddress(String string) {
        return Optional.of(((a)this.toBuilder().host(this.getHost().withValue(string))).build());
    }

    @Generated
    protected u(a<?, ?> a2) {
        super(a2);
        this.proxy = a2.proxy;
        this.host = a2.host;
        this.port = a2.port;
        this.identity = a2.identity;
        this.dontInteractWithSystem = a2.dontInteractWithSystem;
        this.forwardX11 = a2.forwardX11;
        this.jumpServer = a2.jumpServer;
        this.additionalOptions = a2.additionalOptions;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getProxy() {
        return this.proxy;
    }

    @Generated
    public final HostAddress getHost() {
        return this.host;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final Boolean getDontInteractWithSystem() {
        return this.dontInteractWithSystem;
    }

    @Generated
    public final Boolean getForwardX11() {
        return this.forwardX11;
    }

    @Generated
    public final Boolean getJumpServer() {
        return this.jumpServer;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof u)) {
            return false;
        }
        Object object2 = (u)object;
        if (!((u)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((io.xpipe.ext.proc.ssh.b)this).getPort() != ((io.xpipe.ext.proc.ssh.b)object2).getPort()) {
            return false;
        }
        object = this.getDontInteractWithSystem();
        HostAddress hostAddress = ((u)object2).getDontInteractWithSystem();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getForwardX11();
        hostAddress = ((u)object2).getForwardX11();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getJumpServer();
        hostAddress = ((u)object2).getJumpServer();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getProxy();
        hostAddress = ((u)object2).getProxy();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getHost();
        hostAddress = ((u)object2).getHost();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getIdentity();
        hostAddress = ((u)object2).getIdentity();
        if (object == null ? hostAddress != null : !object.equals(hostAddress)) {
            return false;
        }
        object = this.getAdditionalOptions();
        object2 = ((u)object2).getAdditionalOptions();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof u;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 59 + ((io.xpipe.ext.proc.ssh.b)this).getPort();
        Object object = this.getDontInteractWithSystem();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getForwardX11();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getJumpServer();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getProxy();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAdditionalOptions();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "SshStore(super=" + super.toString() + ", proxy=" + String.valueOf(this.getProxy()) + ", host=" + String.valueOf(this.getHost()) + ", port=" + ((io.xpipe.ext.proc.ssh.b)this).getPort() + ", identity=" + String.valueOf(this.getIdentity()) + ", dontInteractWithSystem=" + this.getDontInteractWithSystem() + ", forwardX11=" + this.getForwardX11() + ", jumpServer=" + this.getJumpServer() + ", additionalOptions=" + String.valueOf(this.getAdditionalOptions()) + ")";
    }

    @Generated
    public static abstract class a<C extends u, B extends a<C, B>>
    extends b.a<ShellStoreState, C, B> {
        @Generated
        private DataStoreEntryRef<ShellStore> proxy;
        @Generated
        private HostAddress host;
        @Generated
        private Integer port;
        @Generated
        private IdentityValue identity;
        @Generated
        private Boolean dontInteractWithSystem;
        @Generated
        private Boolean forwardX11;
        @Generated
        private Boolean jumpServer;
        @Generated
        private String additionalOptions;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(u u2, a<?, ?> a2) {
            a2.proxy(u2.proxy);
            a2.host(u2.host);
            a2.port(u2.port);
            a2.identity(u2.identity);
            a2.dontInteractWithSystem(u2.dontInteractWithSystem);
            a2.forwardX11(u2.forwardX11);
            a2.jumpServer(u2.jumpServer);
            a2.additionalOptions(u2.additionalOptions);
        }

        @Generated
        public B proxy(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.proxy = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B host(HostAddress hostAddress) {
            this.host = hostAddress;
            return (B)this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Generated
        public B dontInteractWithSystem(Boolean bl) {
            this.dontInteractWithSystem = bl;
            return (B)this.self();
        }

        @Generated
        public B forwardX11(Boolean bl) {
            this.forwardX11 = bl;
            return (B)this.self();
        }

        @Generated
        public B jumpServer(Boolean bl) {
            this.jumpServer = bl;
            return (B)this.self();
        }

        @Generated
        public B additionalOptions(String string) {
            this.additionalOptions = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SshStore.SshStoreBuilder(super=" + super.toString() + ", proxy=" + String.valueOf(this.proxy) + ", host=" + String.valueOf(this.host) + ", port=" + this.port + ", identity=" + String.valueOf(this.identity) + ", dontInteractWithSystem=" + this.dontInteractWithSystem + ", forwardX11=" + this.forwardX11 + ", jumpServer=" + this.jumpServer + ", additionalOptions=" + this.additionalOptions + ")";
        }
    }

    @JsonTypeName(value="ssh")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<u, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final u build() {
            return new u(this);
        }
    }
}

