/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellSession;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.core.FailableBiFunction;
import io.xpipe.core.FailableSupplier;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.d;
import io.xpipe.ext.proc.ssh.s;
import io.xpipe.ext.proc.ssh.t;
import io.xpipe.ext.proc.tunnel.c;
import io.xpipe.ext.proc.tunnel.j;
import io.xpipe.ext.proc.tunnel.k;
import io.xpipe.ext.proc.tunnel.m;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public abstract class b<T extends ShellStoreState>
implements NetworkTunnelStore,
SelfReferentialStore,
ShellStore,
SingletonSessionStore<ShellSession>,
StatefulDataStore<T>,
UserScopeStore,
DesktopBaseStore,
io.xpipe.ext.proc.d,
j {
    protected String distinctConfigHostName() {
        Object object = this.getSelfEntry();
        object = DataStorage.get().getStoreEntries().contains(object) ? object.getName().replaceAll("\\W", "_") : "config";
        return (String)object + "_xpipe";
    }

    public abstract d toConfigHost();

    public DataStoreEntryRef<?> getNetworkParent() {
        if (this.getGateway() != null) {
            return this.getGateway().asNeeded();
        }
        return null;
    }

    @Override
    public String getTunnelHostName() {
        return this.getHostAddress().get();
    }

    public boolean isLocallyTunnelable() {
        boolean bl = this.dontInteractWithSystem();
        return !bl;
    }

    public NetworkTunnelSession createTunnelSession(int n2, int n3, String string) {
        k k2 = ((c.a)((c.a)((c.a)c.builder().originPort(n2)).remotePort(n3)).remoteAddress(string)).build();
        return this.createTunnelSession(k2);
    }

    private List<b<?>> getGatewayChain() {
        ArrayList arrayList = new ArrayList();
        b b2 = this;
        while (b2.getGateway() != null && b2.getGateway() != null && (b2 = b2.getGateway().getStore()) instanceof b) {
            arrayList.addFirst(b2);
        }
        return arrayList;
    }

    public List<b<?>> getJumpServerChain() {
        b<?> b2;
        List<b<?>> list = this.getGatewayChain();
        ArrayList arrayList = new ArrayList();
        for (int i2 = list.size() - 1; i2 >= 0 && (b2 = list.get(i2)).isJumpServer(); --i2) {
            arrayList.addFirst(b2);
        }
        return arrayList;
    }

    protected void checkValidGatewayChain() {
        ValidationException validationException = this.getGatewayChain();
        boolean bl = false;
        for (int i2 = 0; i2 < validationException.size(); ++i2) {
            b<?> b2 = validationException.get(i2);
            if (b2.isJumpServer()) {
                if (!bl) continue;
                validationException = new ValidationException(AppI18n.get((String)"invalidSshGatewayChain", (Object[])new Object[0]));
                ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)validationException).documentationLink(DocumentationLink.SSH_GATEWAYS));
                throw validationException;
            }
            bl = true;
        }
    }

    private boolean useGatewayAsJumpServer() {
        if (this.getGateway() == null) {
            return false;
        }
        return this.getJumpServerChain().contains(this.getGateway().getStore());
    }

    @Override
    public m createTunnelSession(k k2) {
        FailableSupplier failableSupplier = () -> {
            this.startGatewayTunnelIfNeeded();
            t t2 = this.buildShellControlConfig();
            k2 = t2.ct().tunnelArguments(((k)k2).toTunnelArguments()).build();
            if (this.requiresLocalGatewayTunnel() && this.shouldTunnelToGatewayHost() && !this.canTunnelToGatewayHost()) {
                throw new UnsupportedOperationException("Intermediate system " + this.getGateway().get().getName() + " does not support tunneling");
            }
            return s.a(ProcessControlProvider.get().createLocalProcessControl(true), (t)((Object)k2));
        };
        return m.a(k2, (FailableSupplier<ShellControl>)failableSupplier);
    }

    public t buildShellControlConfig() {
        t t2 = t.cs().baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(string, bl) -> this.buildBaseCommand())).additionalConfig(this.buildBaseConfig().orElse(null)).displayHostName(this.getHostAddress().get()).password(this.getPassword()).identity(this.getIdentityStrategy()).checkLocalhostKey(false).forwardX11(this.hasX11Forward()).noInteraction(this.dontInteractWithSystem()).additionalOptions(this.getAdditionalOptions()).secretId(() -> this.getSelfEntry().getUuid()).sourceStore(this).isForwardedToLocalhost(this.usesGatewayTunnelSession()).jumpServers(this.getJumpServerChain()).build();
        return t2;
    }

    public boolean supportsDesktopAccess() {
        return this.hasX11Forward();
    }

    public void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        this.startSessionIfNeeded();
        string = ((ShellSession)this.getSession()).getShellControl();
        string.command(desktopApplicationStore.getFullCommand()).execute();
    }

    public ShellDialect getUsedDesktopDialect() {
        if (((ShellStoreState)this.getState()).getShellDialect() != null) {
            return ((ShellStoreState)this.getState()).getShellDialect();
        }
        return ShellDialects.BASH;
    }

    protected abstract boolean dontInteractWithSystem();

    protected abstract boolean hasX11Forward();

    public abstract SecretRetrievalStrategy getPassword();

    @Override
    public abstract DataStoreEntryRef<ShellStore> getGateway();

    @Override
    public String getGatewayTunnelTargetIp() {
        return this.getHostAddress().get();
    }

    @Override
    public int getGatewayTunnelTargetPort() {
        return this.getPort();
    }

    @Override
    public boolean shouldTunnelToGatewayHost() {
        return (Boolean)AppPrefs.get().developerDisableSshTunnelGateways().getValue() == false && !this.useGatewayAsJumpServer();
    }

    public abstract HostAddress getHostAddress();

    public abstract UsernameStrategy getUser();

    public abstract int getPort();

    protected abstract CommandBuilder buildBaseCommand();

    public abstract boolean isJumpServer();

    protected Optional<d> buildBaseConfig() {
        return Optional.empty();
    }

    protected abstract SshIdentityStrategy getIdentityStrategy();

    public String toSummary() {
        return this.getUser().getFixedUsername().map(string -> string + "@").orElse("") + (this.getHostAddress() != null ? DataStoreFormatter.formatHostName((String)this.getHostAddress().get(), (int)Integer.MAX_VALUE) : "?") + ":" + this.getPort();
    }

    protected String getEffectiveHostName() {
        if (!this.usesGatewayTunnelSession()) {
            return this.getHostAddress().get();
        }
        return "localhost";
    }

    protected int getEffectivePort() {
        if (!this.usesGatewayTunnelSession()) {
            return this.getPort();
        }
        return this.getLocalGatewayTunnelPort();
    }

    protected abstract boolean hasTunnels();

    protected d getAdditionalOptions() {
        return null;
    }

    public ShellControlFunction shellFunction() {
        return new ShellControlFunction(this){
            private /* synthetic */ b eb;
            {
                this.eb = b2;
            }

            public final ShellControl control() {
                this.eb.startGatewayTunnelIfNeeded();
                Object object = this.eb.buildShellControlConfig();
                object = s.a(ProcessControlProvider.get().createLocalProcessControl(true), (t)object);
                return object;
            }
        };
    }

    @Generated
    protected b(a<T, ?, ?> a2) {
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof b)) {
            return false;
        }
        return ((b)(object = (b)object)).canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof b;
    }

    @Generated
    public int hashCode() {
        return 1;
    }

    @Generated
    public String toString() {
        return "SshBaseStore()";
    }

    @Generated
    public static abstract class a<T extends ShellStoreState, C extends b<T>, B extends a<T, C, B>> {
        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static <T extends ShellStoreState> void $fillValuesFromInstanceIntoBuilder(b<T> b2, a<T, ?, ?> a2) {
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SshBaseStore.SshBaseStoreBuilder()";
        }
    }
}

