/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.rdp;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.HostHelper;
import io.xpipe.app.util.RdpConfig;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.rdp.a;
import io.xpipe.ext.proc.rdp.g;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

@JsonTypeName(value="rdpTunnel")
@JsonDeserialize(builder=b.class)
public final class h
extends io.xpipe.ext.proc.rdp.a
implements SelfReferentialStore,
SingletonSessionStore<NetworkTunnelSession>,
DesktopBaseStore {
    private final DataStoreEntryRef<io.xpipe.ext.proc.ssh.b<?>> tunnelHost;
    private final Integer port;
    private final String additionalOptions;
    private final IdentityValue identity;

    public final void checkComplete() {
        Validators.nonNull(this.tunnelHost);
        Validators.isType(this.tunnelHost, io.xpipe.ext.proc.ssh.b.class);
        this.tunnelHost.checkComplete();
        Validators.nonNull((Object)this.port);
    }

    public final NetworkTunnelSession newSession() {
        int n2 = HostHelper.findRandomOpenPortOnAllLocalInterfaces();
        int n3 = this.port != null ? this.port : 3389;
        return ((io.xpipe.ext.proc.ssh.b)this.tunnelHost.getStore()).createTunnelSession(n2, n3, "localhost");
    }

    public final Class<?> getSessionClass() {
        return NetworkTunnelSession.class;
    }

    private int getTunnelPort() {
        return ((NetworkTunnelSession)this.getSession()).getLocalPort();
    }

    public final boolean supportsDesktopAccess() {
        return true;
    }

    @Override
    protected final SecretRetrievalStrategy getPassword() {
        if (this.identity != null && this.identity.unwrap().getPassword() != null) {
            return this.identity.unwrap().getPassword();
        }
        return ((io.xpipe.ext.proc.ssh.b)this.getTunnelHost().getStore()).getPassword();
    }

    @Override
    public final void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        this.startSessionIfNeeded();
        String string2 = desktopApplicationStore.getPath();
        g.a(this, string2);
        string = this.createLaunchAppConfig(string, string2, desktopApplicationStore.getArguments(), this.retrieveConfig());
        this.launchConfig((RdpConfig)string, true, true);
    }

    @Override
    public final ShellDialect getUsedDesktopDialect() {
        ShellStoreState shellStoreState = (ShellStoreState)((io.xpipe.ext.proc.ssh.b)this.tunnelHost.getStore()).getState();
        if (shellStoreState != null && shellStoreState.getShellDialect() != null) {
            return shellStoreState.getShellDialect();
        }
        return ShellDialects.CMD;
    }

    @Override
    protected final RdpConfig retrieveConfig() {
        Object object = RdpConfig.parseContent((String)this.additionalOptions);
        object = new LinkedHashMap<String, RdpConfig.TypedValue>(object.getContent());
        ((LinkedHashMap)object).putFirst("auto connect", new RdpConfig.TypedValue("i", "1"));
        ((LinkedHashMap)object).putFirst("full address", new RdpConfig.TypedValue("s", "localhost:" + this.getTunnelPort()));
        ((LinkedHashMap)object).putFirst("username", new RdpConfig.TypedValue("s", this.identity != null && this.identity.unwrap().getUsername().hasUser() ? this.identity.unwrap().getUsername().retrieveUsername() : ((io.xpipe.ext.proc.ssh.b)this.getTunnelHost().getStore()).getUser().retrieveUsername()));
        return new RdpConfig((Map)object);
    }

    @Override
    protected final String getDisplayName() {
        return this.getTunnelHost().get().getName();
    }

    @Generated
    protected h(a<?, ?> a2) {
        super(a2);
        this.tunnelHost = a2.tunnelHost;
        this.port = a2.port;
        this.additionalOptions = a2.additionalOptions;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<io.xpipe.ext.proc.ssh.b<?>> getTunnelHost() {
        return this.tunnelHost;
    }

    @Generated
    public final Integer getPort() {
        return this.port;
    }

    @Generated
    public final String getAdditionalOptions() {
        return this.additionalOptions;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof h)) {
            return false;
        }
        h h2 = (h)object;
        if (!h2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getPort();
        Object object2 = h2.getPort();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getTunnelHost();
        object2 = h2.getTunnelHost();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getAdditionalOptions();
        object2 = h2.getAdditionalOptions();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getIdentity();
        h2 = h2.getIdentity();
        return !(object == null ? h2 != null : !object.equals(h2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof h;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getPort();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getTunnelHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAdditionalOptions();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "RdpTunnelStore(super=" + super.toString() + ", tunnelHost=" + String.valueOf(this.getTunnelHost()) + ", port=" + this.getPort() + ", additionalOptions=" + this.getAdditionalOptions() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends h, B extends a<C, B>>
    extends a.a<C, B> {
        @Generated
        private DataStoreEntryRef<io.xpipe.ext.proc.ssh.b<?>> tunnelHost;
        @Generated
        private Integer port;
        @Generated
        private String additionalOptions;
        @Generated
        private IdentityValue identity;

        @Generated
        public B tunnelHost(DataStoreEntryRef<io.xpipe.ext.proc.ssh.b<?>> dataStoreEntryRef) {
            this.tunnelHost = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return (B)this.self();
        }

        @Generated
        public B additionalOptions(String string) {
            this.additionalOptions = string;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RdpTunnelStore.RdpTunnelStoreBuilder(super=" + super.toString() + ", tunnelHost=" + String.valueOf(this.tunnelHost) + ", port=" + this.port + ", additionalOptions=" + this.additionalOptions + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="rdpTunnel")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<h, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final h build() {
            return new h(this);
        }
    }
}

