/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.pss;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.ScriptHelper;
import io.xpipe.app.util.SecretManager;
import io.xpipe.app.util.SecretQuery;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.Validators;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.identity.UsernameStrategy;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonTypeName(value="psSession")
@JsonDeserialize(builder=d.class)
public final class d
implements SelfReferentialStore,
ShellStore,
StatefulDataStore<ShellStoreState>,
UserScopeStore {
    private final DataStoreEntryRef<ShellStore> gateway;
    private final b connectionMethod;
    private final IdentityValue identity;

    private static CommandControl checkWindowsPowershellElevationCommand(ShellControl shellControl) {
        return shellControl.command(String.format("$currentPrincipal = New-Object Security.Principal.WindowsPrincipal([Security.Principal.WindowsIdentity]::GetCurrent());try {if (-not $($currentPrincipal.IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator))) {$host.ui.WriteErrorLine(\"%s\"); throw \"error\"}} catch {}", "XPipe is currently not running as Administrator and can therefore not use PowerShell Remoting."));
    }

    public final boolean isPerUser() {
        return this.identity != null && this.identity.isPerUser();
    }

    public final FileSystem createFileSystem() {
        return new io.xpipe.ext.proc.pss.a(this.standaloneControl());
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(this){
            private /* synthetic */ d dU;
            {
                this.dU = d2;
            }

            public final ShellControl control(ShellControl shellControl) {
                shellControl = io.xpipe.ext.proc.pss.b.a(this.dU, shellControl);
                return shellControl;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)this.dU.getGateway().getStore();
            }
        };
    }

    public final Class<ShellStoreState> getStateClass() {
        return ShellStoreState.class;
    }

    public final void checkComplete() {
        Validators.nonNull((Object)this.connectionMethod);
        this.connectionMethod.checkComplete();
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
        this.identity.checkCompletePassword();
        Validators.nonNull(this.gateway);
        Validators.isType(this.gateway, ShellStore.class);
    }

    public final UsernameStrategy getCredentialUser() {
        if (this.identity != null) {
            return this.identity.unwrap().getUsername();
        }
        return new UsernameStrategy.None();
    }

    public final SecretRetrievalStrategy getCredentialPassword() {
        if (this.identity != null) {
            return this.identity.unwrap().getPassword();
        }
        return null;
    }

    private String createLoginInformation(ShellControl shellControl) {
        if (this.getCredentialPassword() instanceof SecretRetrievalStrategy.None || this.getCredentialPassword() instanceof SecretRetrievalStrategy.Prompt) {
            return "$cred = \"%s\"".formatted(this.getCredentialUser().retrieveUsername());
        }
        if (shellControl.isLocal()) {
            UUID uUID = UUID.randomUUID();
            SecretManager.expectAskpass((UUID)uUID, (UUID)this.getSelfEntry().getUuid(), List.of(this.getCredentialPassword().query()), (SecretQuery)SecretQuery.prompt((boolean)true), List.of(), List.of(), (CountDown)CountDown.of(), (boolean)shellControl.isInteractive());
            shellControl = io.xpipe.ext.proc.util.a.a(shellControl, uUID, this.getSelfEntry().getUuid(), "Password for " + this.getCredentialUser().retrieveUsername());
        } else {
            String string = "Password for " + this.getCredentialUser().retrieveUsername();
            string = SecretManager.retrieve((SecretRetrievalStrategy)this.getCredentialPassword(), (String)string, (UUID)this.getSelfEntry().getUuid(), (int)0, (boolean)shellControl.isInteractive());
            shellControl = ScriptHelper.createTerminalPreparedAskpassScript((SecretValue)string, (ShellControl)shellControl, (boolean)false);
        }
        return String.format("$username = \"%s\"\nSet-ExecutionPolicy -Force -ExecutionPolicy Bypass -Scope Process\n$password = convertto-securestring -String \"$(& \"%s\")\" -AsPlainText -Force\n$cred = new-object -typename System.Management.Automation.PSCredential -argumentlist $username, $password\n", this.getCredentialUser().retrieveUsername(), shellControl).lines().collect(Collectors.joining(";"));
    }

    final CommandBuilder createEnterCommand() {
        return CommandBuilder.of().add(shellControl -> {
            d.checkWindowsPowershellElevationCommand(shellControl).execute();
            String string = this.createLoginInformation(shellControl);
            shellControl = ScriptHelper.createExecScript((ShellControl)shellControl, (String)String.format("%s\n$session = New-PSSession %s -Credential $cred\n\nif ($session) {\n    Enter-PSSession -Session $session\n} else {\n    [Environment]::Exit(1)\n}\n", string, this.connectionMethod.toArguments()));
            return String.format("powershell -NoProfile -NoLogo -ExecutionPolicy RemoteSigned -NoExit -File '%s'", shellControl);
        });
    }

    final CommandBuilder createTerminalEnterCommand(String string) {
        return CommandBuilder.of().add(shellControl -> {
            d.checkWindowsPowershellElevationCommand(shellControl).execute();
            String string = "";
            if (string != null) {
                string = string.strip().split("\\s+");
                string = new String(Base64.getDecoder().decode(string[((String[])string).length - 1]), StandardCharsets.UTF_16LE);
            }
            string = this.createLoginInformation(shellControl);
            return String.format("%s\n$session = New-PSSession %s -Credential $cred\nInvoke-Command -Session $session -ScriptBlock { %s }\nEnter-PSSession -Session $session\n", string, this.connectionMethod.toArguments(), string).lines().collect(Collectors.joining(";"));
        });
    }

    @Generated
    protected d(c<?, ?> c2) {
        this.gateway = c2.gateway;
        this.connectionMethod = c2.connectionMethod;
        this.identity = c2.identity;
    }

    @Generated
    public static c<?, ?> builder() {
        return new d();
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getGateway() {
        return this.gateway;
    }

    @Generated
    public final b getConnectionMethod() {
        return this.connectionMethod;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof d)) {
            return false;
        }
        object = (d)object;
        Object object2 = this.getGateway();
        Object object3 = ((d)object).getGateway();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getConnectionMethod();
        object3 = ((d)object).getConnectionMethod();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getIdentity();
        object = ((d)object).getIdentity();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = this.getGateway();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        b b2 = this.getConnectionMethod();
        n2 = n2 * 59 + (b2 == null ? 43 : b2.hashCode());
        b2 = this.getIdentity();
        n2 = n2 * 59 + (b2 == null ? 43 : b2.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "PsSessionStore(gateway=" + String.valueOf(this.getGateway()) + ", connectionMethod=" + String.valueOf(this.getConnectionMethod()) + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=a.class), @JsonSubTypes.Type(value=e.class)})
    public static interface b {
        public void checkComplete();

        public String toArguments();

        public String toSummary();
    }

    @Generated
    public static abstract class c<C extends d, B extends c<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> gateway;
        @Generated
        private b connectionMethod;
        @Generated
        private IdentityValue identity;

        @Generated
        public B gateway(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B connectionMethod(b b2) {
            this.connectionMethod = b2;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PsSessionStore.PsSessionStoreBuilder(gateway=" + String.valueOf(this.gateway) + ", connectionMethod=" + String.valueOf(this.connectionMethod) + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="psSession")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class d
    extends c<d, d> {
        @Generated
        private d() {
        }

        @Override
        @Generated
        public final d build() {
            return new d(this);
        }
    }

    @JsonTypeName(value="vmId")
    @JsonDeserialize(builder=a.class)
    public static final class e
    implements b {
        private final String vmId;

        @Override
        public final void checkComplete() {
            Validators.nonNull((Object)this.vmId);
        }

        @Override
        public final String toArguments() {
            return "-VmID \"" + this.vmId + "\"";
        }

        @Override
        public final String toSummary() {
            return this.vmId;
        }

        @Generated
        e(String string) {
            this.vmId = string;
        }

        @Generated
        public static a builder() {
            return new a();
        }

        @Generated
        public final String getVmId() {
            return this.vmId;
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof e)) {
                return false;
            }
            object = (e)object;
            String string = this.getVmId();
            object = ((e)object).getVmId();
            return !(string == null ? object != null : !string.equals(object));
        }

        @Generated
        public final int hashCode() {
            String string = this.getVmId();
            int n2 = 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public final String toString() {
            return "PsSessionStore.VmId(vmId=" + this.getVmId() + ")";
        }

        @JsonTypeName(value="vmId")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class a {
            @Generated
            private String vmId;

            @Generated
            a() {
            }

            @Generated
            public a vmId(String string) {
                this.vmId = string;
                return this;
            }

            @Generated
            public e build() {
                return new e(this.vmId);
            }

            @Generated
            public String toString() {
                return "PsSessionStore.VmId.VmIdBuilder(vmId=" + this.vmId + ")";
            }
        }
    }

    @JsonTypeName(value="computerName")
    @JsonDeserialize(builder=a.class)
    public static final class io.xpipe.ext.proc.pss.d$a
    implements b {
        private final String computerName;

        @Override
        public final void checkComplete() {
            Validators.nonNull((Object)this.computerName);
        }

        @Override
        public final String toArguments() {
            return "-ComputerName \"" + this.computerName + "\"";
        }

        @Override
        public final String toSummary() {
            return DataStoreFormatter.formatHostName((String)this.computerName, (int)Integer.MAX_VALUE);
        }

        @Generated
        io.xpipe.ext.proc.pss.d$a(String string) {
            this.computerName = string;
        }

        @Generated
        public static a builder() {
            return new a();
        }

        @Generated
        public final String getComputerName() {
            return this.computerName;
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof io.xpipe.ext.proc.pss.d$a)) {
                return false;
            }
            object = (io.xpipe.ext.proc.pss.d$a)object;
            String string = this.getComputerName();
            object = ((io.xpipe.ext.proc.pss.d$a)object).getComputerName();
            return !(string == null ? object != null : !string.equals(object));
        }

        @Generated
        public final int hashCode() {
            String string = this.getComputerName();
            int n2 = 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public final String toString() {
            return "PsSessionStore.ComputerName(computerName=" + this.getComputerName() + ")";
        }

        @JsonTypeName(value="computerName")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class a {
            @Generated
            private String computerName;

            @Generated
            a() {
            }

            @Generated
            public a computerName(String string) {
                this.computerName = string;
                return this;
            }

            @Generated
            public io.xpipe.ext.proc.pss.d$a build() {
                return new io.xpipe.ext.proc.pss.d$a(this.computerName);
            }

            @Generated
            public String toString() {
                return "PsSessionStore.ComputerName.ComputerNameBuilder(computerName=" + this.computerName + ")";
            }
        }
    }
}

