/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.git;

import com.fasterxml.jackson.databind.JsonNode;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppLayoutModel;
import io.xpipe.app.core.AppResources;
import io.xpipe.app.core.mode.OperationMode;
import io.xpipe.app.core.window.AppDialog;
import io.xpipe.app.ext.PrefsProvider;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.issue.ErrorAction;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ProcessControl;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.WorkingDirectoryFunction;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageSecret;
import io.xpipe.app.storage.DataStorageSyncHandler;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.StorageElement;
import io.xpipe.app.terminal.TerminalLaunch;
import io.xpipe.app.util.AsktextAlert;
import io.xpipe.app.util.CommandSupport;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.EncryptionToken;
import io.xpipe.app.util.Hyperlinks;
import io.xpipe.app.util.LabelGraphic;
import io.xpipe.app.util.LocalShell;
import io.xpipe.core.FailableRunnable;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.NoneStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.g;
import io.xpipe.ext.proc.git.a;
import io.xpipe.ext.proc.git.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.apache.commons.io.FileUtils;

public final class b
implements DataStorageSyncHandler {
    private final Set<DataStoreEntry> cc = new HashSet<DataStoreEntry>();
    private final Set<DataStoreEntry> cd = new HashSet<DataStoreEntry>();
    private final Set<DataStoreCategory> ce = new HashSet<DataStoreCategory>();
    private final Set<DataStoreCategory> cf = new HashSet<DataStoreCategory>();
    private final Map<Path, DataStorageSecret> cg = new HashMap<Path, DataStorageSecret>();
    private final AppLayoutModel.QueueEntry ch;
    private String ci;
    private boolean cj;
    private boolean ck;
    private boolean cl;
    private ShellControl cm;
    private Path cn;
    private boolean enabled;
    private String co;
    private String cp;
    private boolean cq;

    public b() {
        AppLayoutModel.QueueEntry queueEntry;
        this.ch = queueEntry = new AppLayoutModel.QueueEntry(AppI18n.observable((String)"gitSyncPull", (Object[])new Object[0]), (LabelGraphic)new LabelGraphic.IconGraphic("mdi2s-source-branch-refresh"), () -> {});
        this.cj = false;
        this.ck = false;
        this.cl = false;
        this.enabled = false;
    }

    private void aB() {
        ObservableList observableList = AppLayoutModel.get().getQueueEntries();
        if (!observableList.contains((Object)this.ch)) {
            observableList.add((Object)this.ch);
        }
    }

    private void aC() {
        ObservableList observableList = AppLayoutModel.get().getQueueEntries();
        observableList.remove((Object)this.ch);
    }

    private void m(CommandBuilder commandBuilder) {
        this.cm.command(commandBuilder).execute();
    }

    private void a(FailableRunnable<Exception> object) {
        try {
            object.run();
            return;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return;
        }
    }

    private boolean n(CommandBuilder commandBuilder) {
        return this.cm.command(commandBuilder).executeAndCheck();
    }

    /*
     * Unable to fully structure code
     */
    private boolean aD() {
        try {
            var1_1 = this;
            if (OsType.getLocal() == OsType.MACOS) {
                CommandSupport.isInPathOrThrow((ShellControl)var1_1.cm, (String)"git", (String)"Git command-line client", null);
                try {
                    var1_1.m(CommandBuilder.of().add(new String[]{"git"}));
                }
                catch (ProcessOutputException v0) {
                    var1_1 = v0;
                    if (!v0.getOutput().contains("xcode-select")) ** GOTO lbl18
                    throw (ProcessOutputException)ErrorEventFactory.expected((Throwable)ProcessOutputException.withPrefix((String)"Git command-line tools are not available but required. You can install them via one of these methods:\n- Run \"xcode-select --install\" to install Xcode command-line tools which include git\n- Run \"brew install git\" to install it via homebrew\n\nFor more details, see https://git-scm.com/download/mac.\n", (ProcessOutputException)var1_1));
                }
            } else {
                try {
                    var1_1.m(CommandBuilder.of().add((CommandBuilder.Element)LambdaMetafactory.metafactory(null, null, null, (Lio/xpipe/app/process/ShellControl;)Ljava/lang/String;, o(io.xpipe.app.process.ShellControl ), (Lio/xpipe/app/process/ShellControl;)Ljava/lang/String;)()));
                }
                catch (ProcessOutputException var1_2) {
                    var2_7 = "Git command-line tools are not available in the PATH but are required to use git sync. For more details, see https://git-scm.com/downloads.";
                    throw (ProcessOutputException)ErrorEventFactory.expected((Throwable)ProcessOutputException.withPrefix((String)"Git command-line tools are not available in the PATH but are required to use git sync. For more details, see https://git-scm.com/downloads.", (ProcessOutputException)var1_2));
                }
            }
lbl18:
            // 3 sources

            if (OsType.getLocal() == OsType.WINDOWS && (var1_3 = (var1_1 = CommandBuilder.of().add(new String[]{"git", "config", "--global", "--get-all"}).addQuoted("safe.directory").build(this.cm).sensitive().readStdoutIfPossible()).isEmpty() != false || ((String)var1_1.get()).lines().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, ab(java.lang.String ), (Ljava/lang/String;)Z)((b)this)) != false)) {
                CommandBuilder.of().add(new String[]{"git", "config", "--global", "--add"}).addQuoted("safe.directory").addQuoted(this.cn.toString()).build(this.cm).executeAndCheck();
            }
            if (!(var1_4 = Files.exists(this.cn.resolve(".git"), new LinkOption[0]))) {
                this.m(CommandBuilder.of().add(new String[]{"git", "init"}));
            } else {
                try {
                    Files.deleteIfExists(this.cn.resolve(".git").resolve("index.lock"));
                }
                catch (Exception v1) {
                    var1_5 = v1;
                    ErrorEventFactory.fromThrowable((Throwable)v1).omit().expected().handle();
                }
                this.m(CommandBuilder.of().add(new String[]{"git", "reset"}));
            }
            this.m(CommandBuilder.of().add(new String[]{"git", "config", "--local"}).addQuoted("pull.rebase").addQuoted("false"));
            this.m(CommandBuilder.of().add(new String[]{"git", "config", "--local"}).addQuoted("core.autocrlf").addQuoted("false"));
            return true;
        }
        catch (Exception v2) {
            var1_6 = v2;
            ErrorEventFactory.fromThrowable((Throwable)v2).handle();
            this.enabled = false;
            return false;
        }
    }

    private boolean aE() {
        Object object;
        if (this.cp == null || this.cp.isBlank()) {
            return false;
        }
        b.R(this.cp);
        try {
            object = this.cm.command(CommandBuilder.of().add(new String[]{"git", "remote", "get-url"}).addQuoted("remote-storage")).readStdoutIfPossible();
            if (((Optional)object).isEmpty() || !((String)((Optional)object).get()).equals(this.cp)) {
                this.n(CommandBuilder.of().add(new String[]{"git", "remote", "remove"}).addQuoted("remote-storage"));
                this.m(CommandBuilder.of().add(new String[]{"git", "remote", "add"}).addQuoted("remote-storage").addQuoted(this.cp));
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return false;
        }
        while (true) {
            try {
                this.cm.command(a.a(this.cm, CommandBuilder.of().add(new String[]{"git", "fetch", "remote-storage"}))).execute();
                return true;
            }
            catch (ProcessOutputException processOutputException) {
                String string = b.S(this.cp);
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                ErrorAction errorAction = ErrorAction.translated((String)"gitRepoTryAgain", () -> {
                    atomicBoolean.set(true);
                    return Boolean.TRUE;
                });
                ErrorEventFactory.fromThrowable((Throwable)ProcessOutputException.withSuffix((String)string, (ProcessOutputException)processOutputException)).documentationLink(DocumentationLink.SYNC).customAction(errorAction).expected().handle();
                if (atomicBoolean.get()) continue;
                this.enabled = false;
                return false;
            }
            catch (Exception exception) {
                object = exception;
                ErrorEventFactory.fromThrowable((Throwable)exception).handle();
                this.enabled = false;
                return false;
            }
            break;
        }
    }

    private static void R(String string) {
        boolean bl = string.contains("ssh:") || string.contains("@");
        SshIdentityStrategy sshIdentityStrategy = (SshIdentityStrategy)((g)PrefsProvider.get(g.class)).v().getValue();
        if (!bl && sshIdentityStrategy != null && !(sshIdentityStrategy instanceof NoneStrategy)) {
            ErrorEventFactory.fromMessage((String)"You are using an HTTP git URL but have specified an SSH identity option for it. Are you using the correct URL type? Alternatively, remove the git SSH identity option.").expected().handle();
        }
    }

    private static String S(String string) {
        boolean bl = string.contains("ssh:") || string.contains("@");
        String string2 = "- Your SSH identity setting is correct and functional";
        string = "Unable to fetch from remote repository %s\n\nPlease make sure that:\n- You have the correct repository URL\n- Your repository URL matches the rules regarding a .git suffix (Some remotes require a .git suffix, some require it to be omitted, others do not care)\n- Your configured git user has the necessary access right via credentials or a token\n- You have internet connectivity\n%s\n".formatted(string, bl ? string2 : "");
        return string;
    }

    private boolean aF() {
        try {
            if (!this.cl) {
                Path path = this.cn.resolve("README.md");
                Files.writeString(path, (CharSequence)"Waiting for push ...", new OpenOption[0]);
                this.a(path);
                this.d(path.getFileName().toString(), "Initial commit with");
            }
            this.m(CommandBuilder.of().add(new String[]{"git", "push", "--force", "-u", "remote-storage", "HEAD"}));
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private static boolean T(String string) {
        boolean bl = AppDialog.confirm((String)"gitVaultTitle", (ObservableValue)AppI18n.observable((String)("gitVault" + string + "Content"), (Object[])new Object[0]));
        return bl;
    }

    private boolean aG() {
        try {
            FileUtils.cleanDirectory((File)this.cn.toFile());
            FileUtils.forceMkdir((File)this.cn.resolve("data").toFile());
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private boolean aH() {
        try {
            this.cm.command(CommandBuilder.of().add(new String[]{"git", "reset", "--mixed"}).addQuoted("remote-storage/" + this.co)).execute();
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    private void b(boolean bl) {
        try {
            Optional optional;
            boolean bl2;
            Optional optional2;
            if (bl) {
                b b2 = this;
                b2.m(a.a(b2.cm, CommandBuilder.of().add(new String[]{"git", "fetch", "--all"})));
            }
            if ((optional2 = this.cm.command(CommandBuilder.of().add(new String[]{"git", "rev-parse", "--abbrev-ref", "--symbolic-full-name"}).addQuoted("@{u}")).readStdoutIfPossible()).isEmpty()) {
                b b3 = this;
                boolean bl3 = b3.n(a.a(b3.cm, CommandBuilder.of().add(new String[]{"git", "remote", "set-head"}).addQuoted("remote-storage").add(new String[]{"-a"})));
                if (bl3) {
                    String string = this.cm.command(CommandBuilder.of().add(new String[]{"git", "symbolic-ref", "--short", "refs/remotes/remote-storage/HEAD"})).readStdoutOrThrow();
                    this.co = string.replace("remote-storage/", "");
                    bl2 = true;
                } else {
                    this.co = "master";
                    bl2 = false;
                }
                this.n(CommandBuilder.of().add(new String[]{"git", "branch", "-u", "remote-storage/" + this.co}));
            } else {
                this.co = ((String)optional2.get()).replace("remote-storage/", "");
                bl2 = true;
            }
            if (bl2 && ((optional = this.cm.command(CommandBuilder.of().add(new String[]{"git", "rev-list", "HEAD..remote-storage/" + this.co, "--count"})).readStdoutIfPossible()).isEmpty() || !((String)optional.get()).equals("0"))) {
                optional = this.cm.command(a.a(this.cm, CommandBuilder.of().add(new String[]{"git", "pull", "--strategy-option", "theirs", "remote-storage", "HEAD"})));
                String[] stringArray = optional.readStdoutAndStderr();
                stringArray = (String[])Arrays.stream(stringArray).map(string2 -> string2.lines().filter(string -> !string.contains("CRLF will be replaced by LF the next time Git touches it")).collect(Collectors.joining("\n"))).toArray(String[]::new);
                long l2 = optional.getExitCode();
                if (l2 != 0L) {
                    throw ProcessOutputException.of((long)l2, (String[])stringArray);
                }
            }
            if (bl2 && bl && DataStorage.get() != null) {
                DataStorage.get().reloadContent();
            }
            return;
        }
        catch (ProcessOutputException processOutputException) {
            ProcessOutputException processOutputException2 = processOutputException;
            b b4 = this;
            String string = processOutputException2.getOutput();
            if (string.contains("The following untracked working tree files would be overwritten by merge") && b4.U(string)) {
                b4.b(true);
            }
            if (string.contains("Your local changes to the following files would be overwritten by merge:\n\tvaultversion\nPlease commit your changes or stash them before you merge.\n")) {
                b b5 = b4;
                b5.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                    b b2 = this;
                    b2.m(a.a(b2.cm, CommandBuilder.of().add(new String[]{"git", "checkout", "remote-storage/" + this.co, "--", "vaultversion"})));
                }));
                b4.b(false);
            }
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            AtomicBoolean atomicBoolean2 = new AtomicBoolean();
            string = ErrorEventFactory.fromMessage((String)string);
            ErrorAction errorAction = ErrorAction.translated((String)"gitRepoTerminalOpen", () -> {
                TerminalLaunch.builder().title("Git Vault").command((ProcessControl)LocalShell.getShell()).directory(FilePath.of((Path)this.cn)).launch();
                return Boolean.FALSE;
            });
            ErrorAction errorAction2 = ErrorAction.translated((String)"gitRepoOverwriteLocal", () -> {
                if (!b.T("OverwriteLocal")) {
                    return Boolean.FALSE;
                }
                if (this.aG() && this.aD() && this.aE()) {
                    atomicBoolean.set(true);
                    atomicBoolean2.set(true);
                } else {
                    atomicBoolean2.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction3 = ErrorAction.translated((String)"gitRepoOverwriteLocal", () -> {
                if (!b.T("OverwriteLocal")) {
                    return Boolean.FALSE;
                }
                if (this.aH()) {
                    atomicBoolean.set(true);
                    atomicBoolean2.set(true);
                } else {
                    atomicBoolean2.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction4 = ErrorAction.translated((String)"gitRepoForcePush", () -> {
                if (!b.T("ForcePush")) {
                    return Boolean.FALSE;
                }
                if (this.aF()) {
                    atomicBoolean2.set(true);
                    atomicBoolean.set(true);
                } else {
                    atomicBoolean2.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction5 = ErrorAction.translated((String)"gitRepoDisable", () -> {
                atomicBoolean2.set(false);
                return Boolean.TRUE;
            });
            if (processOutputException2.getOutput().contains("Your local changes to the following files would be overwritten by merge") || processOutputException2.getOutput().contains("Automatic merge failed; fix conflicts and then commit the result")) {
                string.customAction(errorAction3);
                string.customAction(errorAction4);
            } else if (processOutputException2.getOutput().contains("refusing to merge unrelated histories") || processOutputException2.getOutput().contains("You have divergent branches and need to specify how to reconcile them")) {
                string.customAction(errorAction2);
                string.customAction(errorAction4);
            }
            string.expected();
            string.customAction(errorAction);
            string.customAction(errorAction5);
            string.handle();
            if (!atomicBoolean2.get()) {
                b4.enabled = false;
            }
            if (atomicBoolean.get()) {
                b4.b(true);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
        }
    }

    private boolean U(String object) {
        Object object2 = new AtomicBoolean();
        object = ((String)object).lines().dropWhile(arg_0 -> b.a((AtomicBoolean)object2, arg_0)).map(string -> {
            string = string.strip();
            try {
                return this.cn.resolve((String)string);
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
        }).filter(path -> path != null && Files.exists(path, new LinkOption[0])).toList();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Path)object.next();
                FileUtils.forceDelete((File)object2.toFile());
            }
            return true;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            return false;
        }
    }

    public final void reset() {
        if (this.cm != null) {
            this.cm.close();
        }
    }

    public final boolean validateConnection() {
        block10: {
            String string = (String)AppPrefs.get().storageGitRemote().get();
            if (string == null || string.isBlank()) {
                return false;
            }
            string = string.strip();
            b.R(string);
            Exception exception = ProcessControlProvider.get().createLocalProcessControl(true).start();
            try {
                Exception exception2 = exception;
                exception2.command(a.a((ShellControl)exception2, CommandBuilder.of().add(new String[]{"git", "ls-remote"}).addQuoted(string))).execute();
                if (exception == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (exception != null) {
                        try {
                            exception.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessOutputException processOutputException) {
                    String string2 = b.S(string);
                    ErrorEventFactory.fromThrowable((Throwable)ProcessOutputException.withSuffix((String)string2, (ProcessOutputException)processOutputException)).documentationLink(DocumentationLink.SYNC).expected().handle();
                    return false;
                }
                catch (Exception exception3) {
                    exception = exception3;
                    ErrorEventFactory.fromThrowable((Throwable)exception3).handle();
                    return false;
                }
            }
            exception.close();
        }
        return true;
    }

    public final boolean supportsSync() {
        return this.enabled;
    }

    public final boolean hasExternalStoredCredentials() {
        return this.cq;
    }

    public final void init() {
        this.cn = DataStorage.getStorageDirectory();
        try {
            FileUtils.forceMkdir((File)this.cn.toFile());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).terminal(true).build().handle();
            this.enabled = false;
            return;
        }
        Object object = (String)AppPrefs.get().storageGitRemote().get();
        if (object != null && !((String)object).isBlank()) {
            this.cp = ((String)object).strip();
        }
        this.enabled = AppPrefs.get().enableGitStorage().get();
        this.cl = Files.exists(this.cn.resolve(".git"), new LinkOption[0]);
        if (this.enabled) {
            this.cm = ProcessControlProvider.get().createLocalProcessControl(true);
            this.cm.setWorkingDirectory(WorkingDirectoryFunction.fixed((FilePath)FilePath.of((String)this.cn.toString())));
            try {
                this.cm.start();
            }
            catch (Exception exception) {
                object = exception;
                ErrorEventFactory.fromThrowable((Throwable)exception).handle();
                this.enabled = false;
                return;
            }
        }
        try {
            object = this.enabled ? this.cm : LocalShell.getShell();
            object = object.command(CommandBuilder.of().add(new String[]{"git", "config", "--list"})).sensitive().readStdoutIfPossible();
            this.cq = ((Optional)object).map(string -> string.contains("credential.")).orElse(Boolean.FALSE);
            return;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).build().handle();
            this.enabled = false;
            return;
        }
    }

    public final void retrieveSyncedData() {
        if (!this.enabled) {
            return;
        }
        if (this.aD() && this.aE()) {
            this.cj = true;
            this.b(false);
            b b2 = this;
            b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                boolean bl = c.aV();
                if (bl) {
                    this.enabled = false;
                }
            }));
            if (!this.enabled) {
                return;
            }
            b2 = this;
            b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
                try {
                    this.cm.command(CommandBuilder.of().add(new String[]{"git", "commit"})).execute();
                    return;
                }
                catch (ProcessOutputException processOutputException) {
                    Object object = processOutputException;
                    object = processOutputException.getOutput();
                    if (((String)object).contains("Author identity unknown")) {
                        boolean bl;
                        Optional optional = this.cm.command("git log -1 --pretty=format:'%an'").readStdoutIfPossible();
                        if (optional.isEmpty()) {
                            optional = AsktextAlert.query((String)"Enter username that should be used as the git commit author", null);
                        }
                        Optional optional2 = this.cm.command("git log -1 --pretty=format:'%ae'").readStdoutIfPossible();
                        if (optional.isPresent() && optional2.isEmpty()) {
                            optional2 = AsktextAlert.query((String)"Enter email address for the git commit author", null);
                        }
                        if (optional.isPresent() && !((String)optional.get()).isBlank() && optional2.isPresent() && !((String)optional2.get()).isBlank() && (bl = this.cm.command(CommandBuilder.of().add(new String[]{"git", "config", "--global", "user.email"}).addQuoted((String)optional2.get())).executeAndCheck() && this.cm.command(CommandBuilder.of().add(new String[]{"git", "config", "--global", "user.name"}).addQuoted((String)optional.get())).executeAndCheck())) {
                            return;
                        }
                        String string = "No git commit author information has been set but is required to create commits. Please configure your name and email for your git commits on the command-line as shown below or in the settings menu and restart XPipe.\n\n" + (String)object;
                        throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException(string));
                    }
                    return;
                }
            }));
            if (!this.enabled) {
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void refreshRemoteData() {
        boolean bl;
        if (!this.enabled) {
            return;
        }
        if (OperationMode.isInShutdown()) {
            return;
        }
        try {
            Object object = this;
            Optional optional = ((b)object).cm.command(a.a(((b)object).cm, CommandBuilder.of().add(new String[]{"git", "ls-remote"}).addQuoted(((b)object).cp).addQuoted("refs/heads/" + ((b)object).co))).sensitive().readStdoutIfPossible();
            if (optional.isEmpty()) return;
            String[] stringArray = ((String)optional.get()).split("\\s+");
            if (stringArray.length != 2) return;
            if (!stringArray[1].equals("refs/heads/" + ((b)object).co)) {
                return;
            }
            String string2 = stringArray[0];
            object = ((b)object).cm.command(CommandBuilder.of().add(new String[]{"git", "cat-file", "-t"}).addQuoted(string2)).sensitive().readStdoutIfPossible();
            if (((Boolean)(object = ((Optional)object).map(string -> string.equals("commit")).orElse(Boolean.FALSE))).booleanValue()) return;
            boolean bl2 = true;
            bl = bl2;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).expected().omit().handle();
            return;
        }
        if (!bl) {
            return;
        }
        b b2 = this;
        b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            this.aB();
            this.b(true);
            this.aC();
        }));
    }

    public final void afterStorageLoad() {
        if (this.enabled) {
            try {
                b b2 = this;
                Path iterable2 = b2.cn.resolve("data");
                FileUtils.forceMkdir((File)iterable2.toFile());
                if (!FileUtils.isEmptyDirectory((File)iterable2.toFile())) {
                    List<Path> list;
                    try (Stream<Path> stream = Files.walk(iterable2, new FileVisitOption[0]);){
                        list = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).toList();
                    }
                    for (Path path2 : list) {
                        if (!path2.toString().endsWith(".enc")) continue;
                        try {
                            String string = Files.readString(path2);
                            string = DataStorageSecret.deserialize((JsonNode)JacksonMapper.getDefault().readTree(string));
                            if (string == null || !string.getEncryptedToken().canDecrypt()) continue;
                            Object object = string.getInternalSecret().getSecretRaw();
                            Path path3 = Path.of(path2.toString().substring(0, path2.toString().length() - 4), new String[0]);
                            byte[] byArray = object;
                            object = path3;
                            File file = path3.toFile();
                            if (!file.canWrite() && file.setWritable(true, true)) {
                                try {
                                    Files.write((Path)object, byArray, new OpenOption[0]);
                                }
                                finally {
                                    file.setWritable(false, true);
                                }
                            } else {
                                Files.write((Path)object, byArray, new OpenOption[0]);
                            }
                            b2.cg.put(path3, (DataStorageSecret)string);
                        }
                        catch (Exception exception) {
                            ErrorEventFactory.fromThrowable((String)("Failed to decrypt data file " + String.valueOf(path2)), (Throwable)exception).handle();
                        }
                    }
                }
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                ErrorEventFactory.fromThrowable((Throwable)exception).handle();
                this.enabled = false;
            }
        }
    }

    public final void beforeStorageSave() {
        if (!this.enabled) {
            return;
        }
        this.cc.clear();
        this.cc.addAll(this.cd);
        this.cd.clear();
        this.ce.clear();
        this.ce.addAll(this.cf);
        this.cf.clear();
        b b2 = this;
        b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            try {
                Object object;
                b b2 = this;
                Path path = b2.cn.resolve("leak_detection");
                if (!Files.exists(path, new LinkOption[0]) && !((Optional)(object = CommandSupport.findProgram((ShellControl)b2.cm, (String)"ssh-keygen"))).isEmpty()) {
                    object = CommandBuilder.of().add(new String[]{"ssh-keygen -q -t rsa -b 4096 -C \"Dummy key for leak detection\" -f"}).addQuoted(path.toString()).add(shellControl -> {
                        if (ShellDialects.isPowershell((ShellControl)shellControl)) {
                            return "-N '\"\"'";
                        }
                        return "-N \"\"";
                    });
                    b2.cm.command((CommandBuilder)object).execute();
                    object = Files.readString(path);
                    object = (String)object + "\n\n# This is a dummy key, designed to allow your git provider to detect potential leaks of\n# this repository, for example if it is made public accidentally.\n# Most git providers should warn you if you have a secret key stored in a\n# publicly accessible repository. They all pretty much are able to detect SSH keys.\n";
                    Files.writeString(path, (CharSequence)object, new OpenOption[0]);
                    FileUtils.deleteQuietly((File)Path.of(String.valueOf(path) + ".pub", new String[0]).toFile());
                    b2.a(path);
                    b2.d(path.getFileName().toString(), "Create");
                }
                this.ci = this.cm.command(CommandBuilder.of().add(new String[]{"git", "status"})).sensitive().readStdoutOrThrow();
                return;
            }
            catch (Exception exception) {
                if (!OperationMode.isInShutdown()) {
                    throw exception;
                }
                return;
            }
        }));
    }

    public final void afterStorageSave() {
        if (!this.enabled) {
            return;
        }
        b b2 = this;
        b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = this.aI();
            boolean bl2 = false;
            Path path = this.cn.resolve("preferences.json");
            if (Files.exists(path, new LinkOption[0])) {
                this.a(path);
                bl2 = this.d(path.getFileName().toString(), "Update");
            }
            boolean bl3 = false;
            Path path2 = this.cn.resolve("vaultkey");
            if (Files.exists(path2, new LinkOption[0])) {
                this.a(path2);
                bl3 = this.d(path2.getFileName().toString(), "Update");
            }
            boolean bl4 = false;
            Path path3 = this.cn.resolve("vaultversion");
            if (Files.exists(path3, new LinkOption[0])) {
                this.a(path3);
                bl4 = this.d(path3.getFileName().toString(), "Update");
            }
            boolean bl5 = false;
            Path path4 = this.cn.resolve("users.json");
            if (Files.exists(path4, new LinkOption[0])) {
                this.a(path4);
                bl5 = this.d(path4.getFileName().toString(), "Update");
            }
            boolean bl6 = false;
            Path path5 = this.cn.resolve("icons");
            if (Files.exists(path5, new LinkOption[0])) {
                this.a(path5);
                bl6 = this.d(path5.getFileName().toString(), "Update");
            }
            boolean bl7 = false;
            Path path6 = this.cn.resolve("notes.md");
            if (Files.exists(path6, new LinkOption[0])) {
                this.a(path6);
                bl7 = this.d(path6.getFileName().toString(), "Update");
            }
            if (!this.cj) {
                return;
            }
            path6 = this.cn.resolve("README.md");
            boolean bl8 = Files.exists(path6, new LinkOption[0]);
            bl = this.ck || bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7;
            if (bl && bl8) {
                Files.writeString(path6, (CharSequence)this.aJ(), new OpenOption[0]);
                this.a(path6);
                this.d(path6.getFileName().toString(), "Update");
            }
            if (bl8) {
                this.c(false);
                return;
            }
            Files.writeString(path6, (CharSequence)this.aJ(), new OpenOption[0]);
            this.a(path6);
            this.d(path6.getFileName().toString(), "Create");
            this.c(false);
            Object object = this;
            if (((b)object).cp == null) return;
            if (((b)object).cp.isBlank()) {
                return;
            }
            bl2 = Pattern.compile("^\\w+:").matcher(((b)object).cp).find();
            bl2 = !((b)object).cp.contains("http") && (bl2 || ((b)object).cp.contains("@"));
            if (bl2) {
                object = ((b)object).cp.replaceAll("^\\w+:(//)?", "").replaceFirst(":", "/").replaceAll("git@", "https://").replaceAll(".git$", "");
                Hyperlinks.open((String)object);
                return;
            }
            Hyperlinks.open((String)((b)object).cp);
        }));
    }

    public final void handleEntry(DataStoreEntry dataStoreEntry, boolean bl, boolean bl2) {
        if (!this.enabled) {
            return;
        }
        boolean bl3 = DataStorage.get().shouldSync(dataStoreEntry);
        if (bl3 && this.cd.add(dataStoreEntry)) {
            this.ck = true;
        }
        if (bl3 && (bl2 || this.a((StorageElement)dataStoreEntry))) {
            this.a(dataStoreEntry.getShareableFiles());
            this.d(DataStorage.get().getStorePath(dataStoreEntry).toString(), bl ? "Update" : "Add");
            this.ck = true;
            return;
        }
        if (!bl3 && this.cc.contains(dataStoreEntry)) {
            this.b(dataStoreEntry.getShareableFiles());
            this.d(DataStorage.get().getStorePath(dataStoreEntry).toString(), "Remove");
            this.ck = true;
        }
    }

    public final void handleCategory(DataStoreCategory dataStoreCategory, boolean bl, boolean bl2) {
        if (!this.enabled) {
            return;
        }
        boolean bl3 = DataStorage.get().shouldSync(dataStoreCategory);
        if (bl3 && this.cf.add(dataStoreCategory)) {
            this.ck = true;
        }
        if (bl3 && (bl2 || this.a((StorageElement)dataStoreCategory))) {
            this.a(dataStoreCategory.getShareableFiles());
            this.d("category " + dataStoreCategory.getName(), bl ? "Update" : "Add");
            this.ck = true;
            return;
        }
        if (!bl3 && this.ce.contains(dataStoreCategory)) {
            this.b(dataStoreCategory.getShareableFiles());
            this.d("category " + dataStoreCategory.getName(), "Remove");
            this.ck = true;
        }
    }

    public final void handleDeletion(Path path, String string) {
        if (!this.enabled) {
            return;
        }
        this.b(path);
        this.d(string, "Remove");
    }

    public final Path getDirectory() {
        return this.cn;
    }

    public final List<Path> getSavedDataFiles() {
        List<Path> list;
        block10: {
            if (!this.enabled) {
                return List.of();
            }
            Object object = this.getDirectory().resolve("data");
            if (!Files.exists((Path)object, new LinkOption[0])) {
                return List.of();
            }
            object = Files.walk((Path)object, new FileVisitOption[0]);
            try {
                List<Path> list2 = object.toList();
                list = list2.stream().filter(path -> Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().endsWith(".enc")).toList();
                if (object == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    object = iOException;
                    ErrorEventFactory.fromThrowable((Throwable)iOException).handle();
                    return List.of();
                }
            }
            object.close();
        }
        return list;
    }

    public final Path getDataFile(Path path) {
        Path path2 = this.getDirectory().resolve("data");
        return path2.resolve(path);
    }

    public final Path addDataFile(Path path, Path path2, boolean bl) {
        Path path3 = this.cn.resolve("data");
        if (!path2.startsWith(path3)) {
            throw new IllegalArgumentException("Target path is not in sync data dir");
        }
        b b2 = this;
        b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> {
            Object object = Files.readAllBytes(path);
            object = b.a(object);
            if (Files.exists(path2, new LinkOption[0])) {
                if (!path.equals(path2)) {
                    Files.delete(path2);
                }
                this.cg.remove(path2);
            }
            FileUtils.forceMkdir((File)path2.getParent().toFile());
            if (!path.equals(path2)) {
                Files.write(path2, object, new OpenOption[0]);
            }
            path = Path.of(String.valueOf(path2) + ".enc", new String[0]);
            bl = bl && DataStorageUserHandler.getInstance().getActiveUser() != null;
            DataStorageSecret dataStorageSecret = DataStorageSecret.ofSecret((SecretValue)InPlaceSecretValue.of((byte[])object), (EncryptionToken)(bl ? EncryptionToken.ofUser() : EncryptionToken.ofVaultKey()));
            object = JacksonMapper.getDefault().writeValueAsString((Object)dataStorageSecret);
            Files.writeString(path, (CharSequence)object, new OpenOption[0]);
            this.cg.put(path2, dataStorageSecret);
            this.cm.command(CommandBuilder.of().add(new String[]{"git", "add"}).addFile(path.toString())).execute();
            this.d(path2.getFileName().toString(), "Update");
        }));
        return path2;
    }

    private static byte[] a(byte[] byArray) {
        String string = new String(byArray, StandardCharsets.UTF_8);
        if (string.contains("PRIVATE KEY-----")) {
            return (string.strip().replaceAll("\r\n", "\n") + "\n").getBytes(StandardCharsets.UTF_8);
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean aI() {
        var1_1 = this.cn.resolve("data");
        FileUtils.forceMkdir((File)var1_1.toFile());
        if (FileUtils.isEmptyDirectory((File)var1_1.toFile())) {
            return false;
        }
        var2_3 = Files.walk((Path)var1_1, new FileVisitOption[0]);
        try {
            var1_1 = var2_3.filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, b(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).toList();
        }
        finally {
            if (var2_3 != null) {
                var2_3.close();
            }
        }
        var2_4 = false;
        var1_1 = var1_1.iterator();
        while (var1_1.hasNext()) {
            var3_6 = (Path)var1_1.next();
            if (var3_6.toString().endsWith(".enc")) continue;
            var4_7 = Path.of(String.valueOf(var3_6) + ".enc", new String[0]);
            var7_11 = Files.size(var3_6);
            if (var7_11 > 1000000L) {
                if (Files.exists(var4_7, new LinkOption[0])) {
                    Files.delete(var4_7);
                }
                this.cm.command(CommandBuilder.of().add(new String[]{"git", "add"}).addFile(var3_6.toString())).execute();
                var2_4 = this.d(var3_6.getFileName().toString(), "Update") != false || var2_4 != false;
                continue;
            }
            var5_8 /* !! */  = this.cg.get(var3_6);
            if (var5_8 /* !! */  == null && Files.exists(var4_7, new LinkOption[0])) continue;
            try {
                var6_9 /* !! */  = Files.readAllBytes(var3_6);
                var6_9 /* !! */  = b.a(var6_9 /* !! */ );
                var6_9 /* !! */  = (byte[])(var5_8 /* !! */  != null && var5_8 /* !! */ .getEncryptedToken().canDecrypt() != false ? DataStorageSecret.ofSecret((SecretValue)InPlaceSecretValue.of((byte[])var6_9 /* !! */ ), (EncryptionToken)var5_8 /* !! */ .getEncryptedToken()) : DataStorageSecret.ofCurrentSecret((SecretValue)InPlaceSecretValue.of((byte[])var6_9 /* !! */ )));
                if (var5_8 /* !! */  == null) ** GOTO lbl-1000
                v0 = var5_8 /* !! */ ;
                if (v0.requiresRewrite(v0.getEncryptedToken().isUser() != false || var5_8 /* !! */ .getEncryptedToken().canDecrypt() == false)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var7_12 = false;
                }
                if (var5_8 /* !! */  != null && !var7_12 && Arrays.equals(var5_8 /* !! */ .getSecret(), var6_9 /* !! */ .getSecret())) continue;
                var5_8 /* !! */  = JacksonMapper.getDefault().writeValueAsString((Object)var6_9 /* !! */ .serialize(true));
                Files.writeString(var4_7, (CharSequence)var5_8 /* !! */ , new OpenOption[0]);
                this.cg.put(var3_6, (DataStorageSecret)var6_9 /* !! */ );
                this.cm.command(CommandBuilder.of().add(new String[]{"git", "add"}).addFile(var4_7.toString())).execute();
                var2_4 = this.d(var3_6.getFileName().toString(), "Update") != false || var2_4 != false;
            }
            catch (Exception var6_10) {
                ErrorEventFactory.fromThrowable((String)("Failed to encrypt data file " + String.valueOf(var3_6)), (Throwable)var6_10).handle();
            }
        }
        return var2_4;
    }

    private void c(boolean bl) {
        try {
            this.a(bl, false);
            this.aC();
            return;
        }
        catch (ProcessOutputException processOutputException) {
            boolean bl2 = bl;
            ProcessOutputException processOutputException2 = processOutputException;
            b b2 = this;
            String string = processOutputException2.getOutput();
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            string = ErrorEventFactory.fromMessage((String)string);
            ErrorAction errorAction = ErrorAction.translated((String)"gitRepoOverwriteLocal", () -> {
                if (!b.T("OverwriteLocal")) {
                    return Boolean.FALSE;
                }
                if (this.aH()) {
                    atomicBoolean.set(true);
                } else {
                    atomicBoolean.set(false);
                }
                return Boolean.TRUE;
            });
            ErrorAction errorAction2 = ErrorAction.translated((String)"gitRepoForcePush", () -> {
                if (!b.T("ForcePush")) {
                    return Boolean.FALSE;
                }
                this.c(true);
                atomicBoolean.set(true);
                return Boolean.TRUE;
            });
            ErrorAction errorAction3 = ErrorAction.translated((String)"gitRepoDisable", () -> {
                atomicBoolean.set(false);
                return Boolean.TRUE;
            });
            if (!bl2 && processOutputException2.getOutput().contains("Updates were rejected because the remote contains work that you")) {
                string.customAction(errorAction2);
            }
            if (processOutputException2.getOutput().contains("By default, updating the current branch in a non-bare repository")) {
                string.documentationLink(DocumentationLink.SYNC_LOCAL);
            } else {
                string.customAction(errorAction);
            }
            string.customAction(errorAction3);
            string.expected();
            string.handle();
            if (!atomicBoolean.get()) {
                b2.enabled = false;
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return;
        }
    }

    private void a(boolean bl, boolean bl2) {
        try {
            CommandBuilder commandBuilder = a.a(this.cm, CommandBuilder.of().add(new String[]{"git", "push"}).addIf(bl, new String[]{"--force"}).add(new String[]{"remote-storage", "HEAD:" + this.co}));
            this.cm.executeSimpleCommand(commandBuilder);
            return;
        }
        catch (ProcessOutputException processOutputException) {
            if (!bl2 && !OperationMode.isInShutdown()) {
                try {
                    this.aB();
                    this.b(true);
                    this.aC();
                    this.a(bl, true);
                    return;
                }
                catch (Exception exception) {
                    processOutputException.addSuppressed((Throwable)exception);
                    throw processOutputException;
                }
            }
            throw processOutputException;
        }
    }

    private boolean a(StorageElement storageElement) {
        String string3 = storageElement instanceof DataStoreEntry ? "stores" : "categories";
        int n2 = this.ci.lines().map(string -> string.strip()).anyMatch(string2 -> string2.equals(string3 + "/"));
        if (n2 != 0) {
            return true;
        }
        n2 = this.ci.indexOf(storageElement.getUuid().toString());
        if (n2 == -1) {
            return false;
        }
        n2 = this.ci.lines().anyMatch(string -> string.contains(storageElement.getUuid().toString()) && Arrays.stream(storageElement.getShareableFiles()).map(path -> path.getFileName().toString()).anyMatch(string2 -> string.contains((CharSequence)string2))) ? 1 : 0;
        boolean bl = this.ci.lines().anyMatch(string -> string.endsWith(storageElement.getUuid().toString() + "/"));
        return n2 != 0 || bl;
    }

    private void a(Path ... pathArray) {
        if (!this.enabled) {
            return;
        }
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"git"}).add(new String[]{"add"});
        for (Path path : pathArray) {
            commandBuilder.addFile(path.toString());
        }
        b b2 = this;
        b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> this.n(commandBuilder)));
    }

    private void b(Path ... pathArray) {
        if (!this.enabled) {
            return;
        }
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"git"}).add(new String[]{"rm"}).add(new String[]{"-r"}).add(new String[]{"--cached"});
        for (Path path : pathArray) {
            commandBuilder.addFile(path.toString());
        }
        b b2 = this;
        b2.a((FailableRunnable<Exception>)((FailableRunnable)() -> this.n(commandBuilder)));
    }

    private boolean d(String object, String string) {
        if (!this.enabled) {
            return false;
        }
        try {
            object = string + " " + object;
            b b2 = this;
            b2.m(a.a(b2.cm, CommandBuilder.of().add(new String[]{"git", "commit", "-m"}).addQuoted(object).discardStdoutOutput()));
            return true;
        }
        catch (ProcessOutputException processOutputException) {
            object = processOutputException;
            if (processOutputException.getOutput().contains("gpg failed to sign the data")) {
                string = "GPG signing of commit failed";
                object = ProcessOutputException.withPrefix((String)"GPG signing of commit failed", (ProcessOutputException)((Object)object));
                ErrorEventFactory.fromThrowable((Throwable)object).handle();
                this.enabled = false;
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            object = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).handle();
            this.enabled = false;
            return false;
        }
    }

    private void a(UUID uUID, Consumer<DataStoreCategory> consumer) {
        this.cf.stream().filter(dataStoreCategory -> dataStoreCategory.getParentCategory().equals(uUID)).sorted((dataStoreCategory, dataStoreCategory2) -> {
            int n2 = dataStoreCategory.getName().compareToIgnoreCase(dataStoreCategory2.getName());
            if (n2 != 0) {
                return -n2;
            }
            return dataStoreCategory.getUuid().compareTo(dataStoreCategory2.getUuid());
        }).forEach(consumer);
    }

    private void a(int n2, DataStoreCategory dataStoreCategory, List<String> list) {
        list.add("  ".repeat(n2) + "- [**" + dataStoreCategory.getName() + "**](categories/" + String.valueOf(dataStoreCategory.getUuid()) + ")");
        this.a(dataStoreCategory.getUuid(), arg_0 -> this.a(++n2, list, arg_0));
    }

    private void a(DataStoreCategory dataStoreCategory2, List<String> list, AtomicBoolean atomicBoolean) {
        Object object = dataStoreCategory2.getName();
        Object object2 = dataStoreCategory2;
        while ((object2 = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(object2.getParentCategory()).orElse(null)) != null) {
            object = object2.getName() + " / " + (String)object;
        }
        list.add("**" + (String)object + "**");
        list.add("");
        object = new AtomicBoolean(false);
        Consumer<DataStoreEntry> consumer = arg_0 -> this.a((AtomicBoolean)object, list, atomicBoolean, arg_0);
        UUID uUID = dataStoreCategory2.getUuid();
        object2 = this;
        object2.cd.stream().filter(dataStoreEntry -> dataStoreEntry.getCategoryUuid().equals(uUID) && DataStorage.get().getDefaultDisplayParent(dataStoreEntry).isEmpty()).sorted((dataStoreEntry, dataStoreEntry2) -> {
            DataStoreCategory dataStoreCategory = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry.getCategoryUuid()).orElseThrow();
            DataStoreCategory dataStoreCategory2 = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry2.getCategoryUuid()).orElseThrow();
            int n2 = dataStoreCategory.getName().compareToIgnoreCase(dataStoreCategory2.getName());
            if (n2 != 0) {
                return n2;
            }
            return DataStorage.get().getStorePath(dataStoreEntry).toString().compareToIgnoreCase(DataStorage.get().getStorePath(dataStoreEntry2).toString());
        }).forEach(consumer);
        if (!((AtomicBoolean)object).get()) {
            list.add("empty");
        }
        list.add("");
        this.a(dataStoreCategory2.getUuid(), (DataStoreCategory dataStoreCategory) -> this.a((DataStoreCategory)dataStoreCategory, list, atomicBoolean));
    }

    private void a(int n2, DataStoreEntry dataStoreEntry4, List<String> object, AtomicBoolean atomicBoolean) {
        object.add((String)("  ".repeat(n2) + "- [**" + dataStoreEntry4.getName() + "**](stores/" + String.valueOf(dataStoreEntry4.getUuid()) + ")"));
        atomicBoolean.set(true);
        object = arg_0 -> this.a(++n2, object, atomicBoolean, arg_0);
        b b2 = this;
        b2.cd.stream().filter(dataStoreEntry3 -> DataStorage.get().getDefaultDisplayParent(dataStoreEntry3).map(dataStoreEntry2 -> dataStoreEntry2.equals((Object)dataStoreEntry4)).orElse(Boolean.FALSE)).filter(dataStoreEntry -> !dataStoreEntry.isPerUserStore()).sorted((dataStoreEntry, dataStoreEntry2) -> {
            DataStoreCategory dataStoreCategory = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry.getCategoryUuid()).orElseThrow();
            DataStoreCategory dataStoreCategory2 = (DataStoreCategory)DataStorage.get().getStoreCategoryIfPresent(dataStoreEntry2.getCategoryUuid()).orElseThrow();
            int n2 = dataStoreCategory.getName().compareToIgnoreCase(dataStoreCategory2.getName());
            if (n2 != 0) {
                return n2;
            }
            return DataStorage.get().getStorePath(dataStoreEntry).toString().compareToIgnoreCase(DataStorage.get().getStorePath(dataStoreEntry2).toString());
        }).forEach((Consumer<DataStoreEntry>)object);
    }

    private String aJ() {
        try {
            Object object = new ArrayList<String>();
            object.add("- **Connections**");
            this.a(DataStorage.ALL_CONNECTIONS_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object.add("- **Scripts**");
            this.a(DataStorage.ALL_SCRIPTS_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object.add("- **Identities**");
            this.a(DataStorage.ALL_IDENTITIES_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object.add("- **Macros**");
            this.a(DataStorage.ALL_MACROS_CATEGORY_UUID, (DataStoreCategory dataStoreCategory) -> this.a(1, (DataStoreCategory)dataStoreCategory, (List<String>)object));
            object = String.join((CharSequence)"\n", object);
            if (((String)object).isEmpty()) {
                object = "No categories were shared. Please make sure that all categories that you want to commit are designated to be shared.";
            }
            Object object2 = new AtomicBoolean();
            Object object3 = new ArrayList();
            this.a(DataStorage.ALL_CONNECTIONS_CATEGORY_UUID, arg_0 -> this.c(object3, (AtomicBoolean)object2, arg_0));
            this.a(DataStorage.ALL_SCRIPTS_CATEGORY_UUID, arg_0 -> this.b(object3, (AtomicBoolean)object2, arg_0));
            this.a(DataStorage.ALL_IDENTITIES_CATEGORY_UUID, arg_0 -> this.a(object3, (AtomicBoolean)object2, arg_0));
            object3 = String.join((CharSequence)"\n", object3);
            if (!((AtomicBoolean)object2).get()) {
                object3 = "No connections were shared. Please make sure that some categories are shared and the connections are sharable. Anything related to the local machine for example is not sharable.";
            }
            AtomicReference<String> atomicReference = new AtomicReference<String>("");
            AppResources.with((String)AppResources.MAIN_MODULE, (String)(((AtomicBoolean)object2).get() ? "misc/vault.md" : "misc/vault_empty.md"), path -> atomicReference.set(Files.readString(path)));
            object2 = atomicReference.get();
            return ((String)object2).formatted(object, object3);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
    }

    private /* synthetic */ void a(List list, AtomicBoolean atomicBoolean, DataStoreCategory dataStoreCategory) {
        this.a(dataStoreCategory, (List<String>)list, atomicBoolean);
    }

    private /* synthetic */ void b(List list, AtomicBoolean atomicBoolean, DataStoreCategory dataStoreCategory) {
        this.a(dataStoreCategory, (List<String>)list, atomicBoolean);
    }

    private /* synthetic */ void c(List list, AtomicBoolean atomicBoolean, DataStoreCategory dataStoreCategory) {
        this.a(dataStoreCategory, (List<String>)list, atomicBoolean);
    }

    private /* synthetic */ void a(int n2, List list, AtomicBoolean atomicBoolean, DataStoreEntry dataStoreEntry) {
        this.a(n2, dataStoreEntry, list, atomicBoolean);
    }

    private /* synthetic */ void a(AtomicBoolean atomicBoolean, List list, AtomicBoolean atomicBoolean2, DataStoreEntry dataStoreEntry) {
        atomicBoolean.set(true);
        this.a(0, dataStoreEntry, list, atomicBoolean2);
    }

    private /* synthetic */ void a(int n2, List list, DataStoreCategory dataStoreCategory) {
        this.a(n2, dataStoreCategory, list);
    }

    private static /* synthetic */ boolean b(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private static /* synthetic */ boolean a(AtomicBoolean atomicBoolean, String string) {
        return !atomicBoolean.getAndSet(string.contains("The following untracked working tree files would be overwritten by merge"));
    }

    private /* synthetic */ boolean ab(String string) {
        return string.equals(this.cn.toString());
    }

    private static /* synthetic */ String o(ShellControl shellControl) {
        return shellControl.getShellDialect().getWhichCommand("git");
    }
}

