/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.env;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ParentSystemAccess;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellEnvironmentStoreState;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.process.ShellTerminalInitCommand;
import io.xpipe.app.process.SystemState;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.CommandSupport;
import io.xpipe.app.util.Validators;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.script.ScriptStore;
import io.xpipe.ext.base.script.ScriptStoreSetup;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="shellEnvironment")
@JsonDeserialize(builder=b.class)
public final class r
implements ShellStore,
StatefulDataStore<ShellEnvironmentStoreState> {
    private final String commands;
    private final DataStoreEntryRef<ShellStore> host;
    private final ShellDialect shell;
    private final boolean elevated;
    private final String user;
    private final List<DataStoreEntryRef<ScriptStore>> scripts;

    public final Class<ShellEnvironmentStoreState> getStateClass() {
        return ShellEnvironmentStoreState.class;
    }

    public final void checkComplete() {
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        this.host.checkComplete();
    }

    public final List<DataStoreEntryRef<ScriptStore>> getEffectiveScripts() {
        if (this.scripts != null) {
            return this.scripts.stream().filter(dataStoreEntryRef -> dataStoreEntryRef != null).toList();
        }
        return List.of();
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public final ShellControl control(ShellControl shellControl) {
                ShellControl shellControl2 = shellControl;
                if (r.this.shell != null) {
                    r.this.checkCompatibility(shellControl);
                    shellControl = r.this.shell.getDumbMode().getSwitchDialect();
                    shellControl2 = shellControl2.subShell();
                    shellControl2.setDumbOpen(new ShellOpenFunction(){
                        private /* synthetic */ ShellDialect bR;
                        private /* synthetic */ 1 bS;
                        {
                            this.bR = shellDialect;
                            this.bS = var1_1;
                        }

                        public final CommandBuilder prepareWithoutInitCommand() {
                            1 v0 = this;
                            return CommandBuilder.of().addAll(shellControl -> {
                                this.bS.r.this.checkCompatibility((ShellControl)shellControl);
                                if (v0.bR != null) {
                                    return v0.bR.getLaunchCommand().loginCommand(shellControl.getOsType());
                                }
                                return this.bS.r.this.shell.getLaunchCommand().loginCommand(shellControl.getOsType());
                            });
                        }

                        public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                            if (string == null) {
                                throw new NullPointerException("command is marked non-null but is null");
                            }
                            return CommandBuilder.ofString((String)string);
                        }
                    });
                    shellControl2.setTerminalOpen(new ShellOpenFunction(this){
                        private /* synthetic */ 1 bS;
                        {
                            this.bS = var1_1;
                        }

                        public final CommandBuilder prepareWithoutInitCommand() {
                            return CommandBuilder.of().addAll(shellControl -> {
                                this.bS.r.this.checkCompatibility((ShellControl)shellControl);
                                return this.bS.r.this.shell.getLaunchCommand().loginCommand(shellControl.getOsType());
                            });
                        }

                        public final CommandBuilder prepareWithInitCommand(@NonNull String string) {
                            if (string == null) {
                                throw new NullPointerException("command is marked non-null but is null");
                            }
                            return CommandBuilder.ofString((String)string);
                        }
                    });
                    shellControl2.setOriginalShellDialect(r.this.shell);
                } else {
                    shellControl2 = shellControl2.identicalDialectSubShell();
                }
                shellControl2.setUser(r.this.user);
                shellControl2.setParentSystemAccess(ParentSystemAccess.identity());
                if (r.this.isElevated()) {
                    shellControl2.elevated(ElevationFunction.elevated(null));
                }
                if (r.this.commands != null) {
                    shellControl2.withInitSnippet(new ShellTerminalInitCommand(this){
                        private /* synthetic */ 1 bS;
                        {
                            this.bS = var1_1;
                        }

                        public final Optional<String> terminalContent(ShellControl shellControl) {
                            return Optional.of(this.bS.r.this.commands);
                        }

                        public final boolean canPotentiallyRunInDialect(ShellDialect shellDialect) {
                            return true;
                        }
                    });
                }
                shellControl2.withSourceStore((DataStore)r.this);
                shellControl2.withShellStateInit((StatefulDataStore)r.this);
                shellControl2.withShellStateFail((StatefulDataStore)r.this);
                shellControl2.onInit(object -> {
                    if ((object = object.getOriginalShellDialect().queryVersion(object)) != null) {
                        r.this.setState((DataStoreState)((ShellEnvironmentStoreState)r.this.getState()).toBuilder().shellName((String)object).build());
                    }
                });
                ScriptStoreSetup.controlWithScripts((ShellControl)shellControl2, r.this.getEffectiveScripts());
                return shellControl2;
            }

            public final ShellStore getParentStore() {
                return (ShellStore)r.this.host.getStore();
            }
        };
    }

    public final void validate() {
        block7: {
            block6: {
                block5: {
                    if (this.shell == null || this.shell.getDumbMode().supportsAnyPossibleInteraction()) break block6;
                    ShellControl shellControl = ((ShellStore)this.getHost().getStore()).tempControl().start();
                    try {
                        CommandSupport.isInPathOrThrow((ShellControl)shellControl, (String)this.shell.getExecutableName());
                        if (shellControl == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (shellControl != null) {
                            try {
                                shellControl.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    shellControl.close();
                    break block7;
                }
                return;
            }
            super.validate();
        }
    }

    private void checkCompatibility(ShellControl object) {
        OsType.Any any = object.getOsType();
        if (any != null) {
            this.throwIfUnsupported(any);
            return;
        }
        if ((object = object.getSourceStore()).isPresent() && (object = object.get()) instanceof StatefulDataStore) {
            object = (StatefulDataStore)object;
            if ((object = object.getState()) instanceof SystemState) {
                object = (SystemState)object;
                if ((object = (OsType.Any)object.getOsType()) != null) {
                    this.throwIfUnsupported((OsType.Any)object);
                }
            }
        }
    }

    private void throwIfUnsupported(OsType.Any any) {
        boolean bl = this.getAvailableDialects(any).contains(this.shell);
        if (!bl) {
            throw (UnsupportedOperationException)ErrorEventFactory.expected((Throwable)new UnsupportedOperationException("Shell type " + this.shell.getDisplayName() + " is not supported for " + any.getName() + " systems"));
        }
    }

    private List<ShellDialect> getAvailableDialects(OsType.Any any) {
        OsType.Any any2 = any;
        Objects.requireNonNull(any2);
        any = any2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Bsd.class, OsType.Linux.class, OsType.MacOs.class, OsType.Solaris.class, OsType.Windows.class}, (OsType.Any)any2, 0)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                OsType.Bsd cfr_ignored_0 = (OsType.Bsd)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.NUSHELL);
            }
            case 1: {
                OsType.Linux cfr_ignored_1 = (OsType.Linux)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.POWERSHELL_CORE, ShellDialects.NUSHELL, ShellDialects.XONSH);
            }
            case 2: {
                OsType.MacOs cfr_ignored_2 = (OsType.MacOs)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.POWERSHELL_CORE, ShellDialects.NUSHELL);
            }
            case 3: {
                OsType.Solaris cfr_ignored_3 = (OsType.Solaris)any;
                return List.of(ShellDialects.SH, ShellDialects.BASH, ShellDialects.ZSH, ShellDialects.FISH, ShellDialects.ASH, ShellDialects.DASH, ShellDialects.NUSHELL);
            }
            case 4: 
        }
        OsType.Windows cfr_ignored_4 = (OsType.Windows)any;
        return List.of(ShellDialects.CMD, ShellDialects.POWERSHELL, ShellDialects.POWERSHELL_CORE, ShellDialects.NUSHELL);
    }

    @Generated
    protected r(a<?, ?> a2) {
        this.commands = a2.commands;
        this.host = a2.host;
        this.shell = a2.shell;
        this.elevated = a2.elevated;
        this.user = a2.user;
        this.scripts = a2.scripts;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final String getCommands() {
        return this.commands;
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final ShellDialect getShell() {
        return this.shell;
    }

    @Generated
    public final boolean isElevated() {
        return this.elevated;
    }

    @Generated
    public final String getUser() {
        return this.user;
    }

    @Generated
    public final List<DataStoreEntryRef<ScriptStore>> getScripts() {
        return this.scripts;
    }

    @Generated
    public final boolean equals(Object list) {
        if (list == this) {
            return true;
        }
        if (!(list instanceof r)) {
            return false;
        }
        list = (r)((Object)list);
        if (this.isElevated() != ((r)((Object)list)).isElevated()) {
            return false;
        }
        Object object = this.getCommands();
        Object object2 = ((r)((Object)list)).getCommands();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getHost();
        object2 = ((r)((Object)list)).getHost();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getShell();
        object2 = ((r)((Object)list)).getShell();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getUser();
        object2 = ((r)((Object)list)).getUser();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getScripts();
        list = ((r)((Object)list)).getScripts();
        return !(object == null ? list != null : !object.equals(list));
    }

    @Generated
    public final int hashCode() {
        int n2 = 59 + (this.isElevated() ? 79 : 97);
        Object object = this.getCommands();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getShell();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getUser();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getScripts();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "ShellEnvironmentStore(commands=" + this.getCommands() + ", host=" + String.valueOf(this.getHost()) + ", shell=" + String.valueOf(this.getShell()) + ", elevated=" + this.isElevated() + ", user=" + this.getUser() + ", scripts=" + String.valueOf(this.getScripts()) + ")";
    }

    @Generated
    public r(String string, DataStoreEntryRef<ShellStore> dataStoreEntryRef, ShellDialect shellDialect, boolean bl, String string2, List<DataStoreEntryRef<ScriptStore>> list) {
        this.commands = string;
        this.host = dataStoreEntryRef;
        this.shell = shellDialect;
        this.elevated = bl;
        this.user = string2;
        this.scripts = list;
    }

    @Generated
    public static abstract class a<C extends r, B extends a<C, B>> {
        @Generated
        private String commands;
        @Generated
        private DataStoreEntryRef<ShellStore> host;
        @Generated
        private ShellDialect shell;
        @Generated
        private boolean elevated;
        @Generated
        private String user;
        @Generated
        private List<DataStoreEntryRef<ScriptStore>> scripts;

        @Generated
        public B commands(String string) {
            this.commands = string;
            return this.self();
        }

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B shell(ShellDialect shellDialect) {
            this.shell = shellDialect;
            return this.self();
        }

        @Generated
        public B elevated(boolean bl) {
            this.elevated = bl;
            return this.self();
        }

        @Generated
        public B user(String string) {
            this.user = string;
            return this.self();
        }

        @Generated
        public B scripts(List<DataStoreEntryRef<ScriptStore>> list) {
            this.scripts = list;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ShellEnvironmentStore.ShellEnvironmentStoreBuilder(commands=" + this.commands + ", host=" + String.valueOf(this.host) + ", shell=" + String.valueOf(this.shell) + ", elevated=" + this.elevated + ", user=" + this.user + ", scripts=" + String.valueOf(this.scripts) + ")";
        }
    }

    @JsonTypeName(value="shellEnvironment")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<r, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final r build() {
            return new r(this);
        }
    }
}

