/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.ext.base.service.AbstractServiceStore;
import java.util.HashMap;
import java.util.Map;

public class ServiceAddressRotation {
    private static final Map<String, String> replacedUrls = new HashMap<String, String>();
    private static int counter = 0;
    private static final String[] aliases = new String[]{"localhost", "127.0.0.1"};

    private static String getRotatedLocalhost(String url) {
        if (!url.startsWith("localhost")) {
            return url;
        }
        if (replacedUrls.containsKey(url)) {
            return replacedUrls.get(url);
        }
        String alias = aliases[counter++ % aliases.length];
        String replaced = url.replaceFirst("localhost", alias);
        replacedUrls.put(url, replaced);
        return replaced;
    }

    public static String getRotatedAddress(AbstractServiceStore serviceStore) {
        NetworkTunnelSession s = (NetworkTunnelSession)serviceStore.getSession();
        if (s == null) {
            String host = ((NetworkTunnelStore)serviceStore.getHost().getStore()).getTunnelHostName() != null ? ((NetworkTunnelStore)serviceStore.getHost().getStore()).getTunnelHostName() : "localhost";
            return ServiceAddressRotation.getRotatedLocalhost(host + ":" + serviceStore.getRemotePort());
        }
        return ServiceAddressRotation.getRotatedLocalhost("localhost:" + s.getLocalPort());
    }
}

