/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.HostHelper;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.service.ServiceAddressRotation;
import io.xpipe.ext.base.service.ServiceProtocolType;
import lombok.Generated;

public abstract class AbstractServiceStore
implements SingletonSessionStore<NetworkTunnelSession>,
DataStore {
    private final Integer remotePort;
    private final Integer localPort;
    private final ServiceProtocolType serviceProtocolType;

    public abstract DataStoreEntryRef<NetworkTunnelStore> getHost();

    public boolean licenseRequired() {
        return true;
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.getHost());
        NetworkTunnelStore.checkTunnelable(this.getHost());
        Validators.nonNull((Object)this.remotePort);
        Validators.nonNull((Object)this.serviceProtocolType);
    }

    public String getOpenTargetUrl() {
        return ServiceAddressRotation.getRotatedAddress(this);
    }

    public boolean requiresTunnel() {
        if (this.getHost() == null) {
            return false;
        }
        if (!((NetworkTunnelStore)this.getHost().getStore()).isLocallyTunnelable()) {
            DataStoreEntryRef parent = ((NetworkTunnelStore)this.getHost().getStore()).getNetworkParent();
            if (!(parent instanceof NetworkTunnelStore)) {
                return false;
            }
            NetworkTunnelStore nts = (NetworkTunnelStore)parent;
            return nts.requiresTunnel();
        }
        return ((NetworkTunnelStore)this.getHost().getStore()).requiresTunnel();
    }

    public NetworkTunnelSession newSession() throws Exception {
        long active;
        LicensedFeature f = LicenseProvider.get().getFeature("services");
        if (this.licenseRequired() && !f.isSupported() && (active = DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> {
            AbstractServiceStore a;
            DataStore patt0$temp = dataStoreEntry.getStore();
            return patt0$temp instanceof AbstractServiceStore && (a = (AbstractServiceStore)patt0$temp) != this && a.licenseRequired() && a.isSessionRunning();
        }).count()) > 0L) {
            f.throwIfUnsupported();
        }
        int l = this.localPort != null ? this.localPort : HostHelper.findRandomOpenPortOnAllLocalInterfaces();
        DataStoreEntryRef parent = ((NetworkTunnelStore)this.getHost().getStore()).getNetworkParent();
        if (!((NetworkTunnelStore)this.getHost().getStore()).isLocallyTunnelable() && parent instanceof NetworkTunnelStore) {
            NetworkTunnelStore nts = (NetworkTunnelStore)parent;
            return nts.createTunnelSession(l, this.remotePort.intValue(), nts.getTunnelHostName() != null ? nts.getTunnelHostName() : "localhost");
        }
        return ((NetworkTunnelStore)this.getHost().getStore()).createTunnelSession(l, this.remotePort.intValue(), "localhost");
    }

    public Class<?> getSessionClass() {
        return NetworkTunnelSession.class;
    }

    @Generated
    protected AbstractServiceStore(AbstractServiceStoreBuilder<?, ?> b) {
        this.remotePort = b.remotePort;
        this.localPort = b.localPort;
        this.serviceProtocolType = b.serviceProtocolType;
    }

    @Generated
    public Integer getRemotePort() {
        return this.remotePort;
    }

    @Generated
    public Integer getLocalPort() {
        return this.localPort;
    }

    @Generated
    public ServiceProtocolType getServiceProtocolType() {
        return this.serviceProtocolType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractServiceStore)) {
            return false;
        }
        AbstractServiceStore other = (AbstractServiceStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$remotePort = this.getRemotePort();
        Integer other$remotePort = other.getRemotePort();
        if (this$remotePort == null ? other$remotePort != null : !((Object)this$remotePort).equals(other$remotePort)) {
            return false;
        }
        Integer this$localPort = this.getLocalPort();
        Integer other$localPort = other.getLocalPort();
        if (this$localPort == null ? other$localPort != null : !((Object)this$localPort).equals(other$localPort)) {
            return false;
        }
        ServiceProtocolType this$serviceProtocolType = this.getServiceProtocolType();
        ServiceProtocolType other$serviceProtocolType = other.getServiceProtocolType();
        return !(this$serviceProtocolType == null ? other$serviceProtocolType != null : !this$serviceProtocolType.equals(other$serviceProtocolType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractServiceStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $remotePort = this.getRemotePort();
        result = result * 59 + ($remotePort == null ? 43 : ((Object)$remotePort).hashCode());
        Integer $localPort = this.getLocalPort();
        result = result * 59 + ($localPort == null ? 43 : ((Object)$localPort).hashCode());
        ServiceProtocolType $serviceProtocolType = this.getServiceProtocolType();
        result = result * 59 + ($serviceProtocolType == null ? 43 : $serviceProtocolType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractServiceStore(remotePort=" + this.getRemotePort() + ", localPort=" + this.getLocalPort() + ", serviceProtocolType=" + String.valueOf(this.getServiceProtocolType()) + ")";
    }

    @Generated
    public static abstract class AbstractServiceStoreBuilder<C extends AbstractServiceStore, B extends AbstractServiceStoreBuilder<C, B>> {
        @Generated
        private Integer remotePort;
        @Generated
        private Integer localPort;
        @Generated
        private ServiceProtocolType serviceProtocolType;

        @Generated
        public B remotePort(Integer remotePort) {
            this.remotePort = remotePort;
            return this.self();
        }

        @Generated
        public B localPort(Integer localPort) {
            this.localPort = localPort;
            return this.self();
        }

        @Generated
        public B serviceProtocolType(ServiceProtocolType serviceProtocolType) {
            this.serviceProtocolType = serviceProtocolType;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractServiceStore.AbstractServiceStoreBuilder(remotePort=" + this.remotePort + ", localPort=" + this.localPort + ", serviceProtocolType=" + String.valueOf(this.serviceProtocolType) + ")";
        }
    }
}

