/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.ContextualFileReferenceChoiceComp;
import io.xpipe.app.comp.base.ContextualFileReferenceSync;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.ContextualFileReference;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.util.OptionsBuilder;
import io.xpipe.app.util.SecretRetrievalStrategy;
import io.xpipe.app.util.SecretRetrievalStrategyHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import lombok.Generated;

@JsonTypeName(value="file")
@JsonDeserialize(builder=KeyFileStrategyBuilder.class)
public final class KeyFileStrategy
implements SshIdentityStrategy {
    private final ContextualFileReference file;
    private final SecretRetrievalStrategy password;

    public static String getOptionsNameKey() {
        return "keyFile";
    }

    public static OptionsBuilder createOptions(Property<KeyFileStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleObjectProperty keyPath = new SimpleObjectProperty(p.getValue() != null && ((KeyFileStrategy)p.getValue()).getFile() != null ? ((KeyFileStrategy)p.getValue()).getFile().toAbsoluteFilePath(null) : null);
        p.addListener((observable, oldValue, newValue) -> {
            if (keyPath.get() != null && newValue != null && !ContextualFileReference.of((FilePath)((FilePath)keyPath.get())).equals((Object)newValue.getFile())) {
                return;
            }
            keyPath.setValue(newValue != null && newValue.getFile() != null ? newValue.getFile().toAbsoluteFilePath(null) : null);
        });
        SimpleObjectProperty keyPasswordProperty = new SimpleObjectProperty(p.getValue() != null ? ((KeyFileStrategy)p.getValue()).getPassword() : null);
        ContextualFileReferenceSync sync = ContextualFileReferenceSync.of((Path)DataStorage.get().getDataDir().resolve("keys"), file -> file.getFileName().toString(), config.getPerUserKeyFileCheck());
        return new OptionsBuilder().name("location").description("locationDescription").addComp((Comp)new ContextualFileReferenceChoiceComp(config.getProxy(), (Property)keyPath, (ContextualFileReferenceSync)(config.isAllowKeyFileSync() ? sync : null), List.of(), e -> e.equals((Object)DataStorage.get().local())), (Property)keyPath).nonNull().name("keyPassword").description("sshConfigHost.identityPassphraseDescription").sub(SecretRetrievalStrategyHelper.comp((Property)keyPasswordProperty, (boolean)true), (Property)keyPasswordProperty).nonNull().bind(() -> new KeyFileStrategy(ContextualFileReference.of((FilePath)((FilePath)keyPath.get())), (SecretRetrievalStrategy)keyPasswordProperty.get()), new Property[]{p});
    }

    @Override
    public void checkComplete() throws ValidationException {
        Validators.nonNull((Object)this.file);
        Validators.nonNull((Object)this.password);
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        if (this.file == null) {
            return;
        }
        FilePath s = this.file.toAbsoluteFilePath(parent);
        if (s.startsWith("~")) {
            s = s.resolveTildeHome(parent.view().userHome());
        }
        String resolved = parent.getShellDialect().evaluateExpression(parent, s.toString()).readStdoutOrThrow();
        if (!parent.getShellDialect().createFileExistsCommand(parent, resolved).executeAndCheck()) {
            Optional<String> systemName = parent.getSourceStore().flatMap(shellStore -> DataStorage.get().getStoreEntryIfPresent(shellStore, false)).map(e -> DataStorage.get().getStoreEntryDisplayName(e));
            String msg = "Identity file " + resolved + " does not exist" + (String)(systemName.isPresent() ? " on system " + systemName.get() : "");
            throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException(msg));
        }
        if (resolved.endsWith(".ppk")) {
            IllegalArgumentException ex = new IllegalArgumentException("Identity file " + resolved + " is in non-standard PuTTY Private Key format (.ppk), which is not supported by OpenSSH. Please export/convert it to a standard format like .pem via PuTTY");
            ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)ex).expected().link("https://www.puttygen.com/convert-pem-to-ppk"));
            throw ex;
        }
        if (resolved.endsWith(".pub")) {
            throw (IllegalArgumentException)ErrorEventFactory.expected((Throwable)new IllegalArgumentException("Identity file " + resolved + " is marked to be a public key file, SSH authentication requires the private key"));
        }
        if (parent.getOsType() != OsType.WINDOWS) {
            parent.command(CommandBuilder.of().add(new String[]{"test", "-w"}).addFile(resolved).add(new String[]{"&&", "chmod", "600"}).addFile(resolved).add(new String[]{"||", "chmod", "400"}).addFile(resolved)).executeAndCheck();
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
    }

    @Override
    public List<KeyValue> configOptions() {
        return List.of(new KeyValue("IdentitiesOnly", "yes"), new KeyValue("IdentityAgent", "none"), new KeyValue("IdentityFile", "\"" + this.resolveFilePath().toString() + "\""), new KeyValue("PKCS11Provider", "none"));
    }

    @Override
    public SecretRetrievalStrategy getAskpassStrategy() {
        return this.password;
    }

    private FilePath resolveFilePath() {
        FilePath s = this.file.toLocalAbsoluteFilePath();
        if (s.startsWith("~")) {
            s = s.resolveTildeHome(FilePath.of((Path)AppSystemInfo.ofCurrent().getUserHome()));
        }
        return s;
    }

    @Generated
    public static KeyFileStrategyBuilder builder() {
        return new KeyFileStrategyBuilder();
    }

    @Generated
    public ContextualFileReference getFile() {
        return this.file;
    }

    @Generated
    public SecretRetrievalStrategy getPassword() {
        return this.password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyFileStrategy)) {
            return false;
        }
        KeyFileStrategy other = (KeyFileStrategy)o;
        ContextualFileReference this$file = this.getFile();
        ContextualFileReference other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        SecretRetrievalStrategy this$password = this.getPassword();
        SecretRetrievalStrategy other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContextualFileReference $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        SecretRetrievalStrategy $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyFileStrategy(file=" + String.valueOf(this.getFile()) + ", password=" + String.valueOf(this.getPassword()) + ")";
    }

    @Generated
    public KeyFileStrategy(ContextualFileReference file, SecretRetrievalStrategy password) {
        this.file = file;
        this.password = password;
    }

    @JsonTypeName(value="file")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class KeyFileStrategyBuilder {
        @Generated
        private ContextualFileReference file;
        @Generated
        private SecretRetrievalStrategy password;

        @Generated
        KeyFileStrategyBuilder() {
        }

        @Generated
        public KeyFileStrategyBuilder file(ContextualFileReference file) {
            this.file = file;
            return this;
        }

        @Generated
        public KeyFileStrategyBuilder password(SecretRetrievalStrategy password) {
            this.password = password;
            return this;
        }

        @Generated
        public KeyFileStrategy build() {
            return new KeyFileStrategy(this.file, this.password);
        }

        @Generated
        public String toString() {
            return "KeyFileStrategy.KeyFileStrategyBuilder(file=" + String.valueOf(this.file) + ", password=" + String.valueOf(this.password) + ")";
        }
    }
}

