/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.podman;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerImageStore;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.InternalCacheDataStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.FixedServiceCreatorStore;
import io.xpipe.ext.base.service.MappedServiceStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.system.podman.PodmanCmdStore;
import io.xpipe.ext.system.podman.PodmanCommandView;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@JsonTypeName(value="podman")
@JsonDeserialize(builder=PodmanContainerStoreBuilderImpl.class)
public final class PodmanContainerStore
implements StartableStore,
StoppableStore,
ShellStore,
InternalCacheDataStore,
FixedChildStore,
StatefulDataStore<ContainerStoreState>,
FixedServiceCreatorStore,
SelfReferentialStore,
ContainerImageStore,
NameableStore {
    private final DataStoreEntryRef<PodmanCmdStore> cmd;
    private final String containerName;

    public String getName() {
        return this.containerName;
    }

    public String getImageName() {
        return ((ContainerStoreState)this.getState()).getImageName();
    }

    public PodmanCommandView.Container commandView(ShellControl parent) {
        return new PodmanCommandView(parent).container();
    }

    public void start() throws Exception {
        ShellControl sc = ((ShellStore)((PodmanCmdStore)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
        PodmanCommandView.Container view = this.commandView(sc);
        view.start(this.containerName);
        this.refreshContainerState(sc);
    }

    public void stop() throws Exception {
        ShellControl sc = ((ShellStore)((PodmanCmdStore)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
        PodmanCommandView.Container view = this.commandView(sc);
        view.stop(this.containerName);
        this.refreshContainerState(sc);
    }

    public List<? extends DataStoreEntryRef<? extends AbstractServiceStore>> createFixedServices() throws Exception {
        return this.findServices().stream().map(s -> DataStoreEntry.createNew((String)"Service", (DataStore)s).ref()).toList();
    }

    private List<MappedServiceStore> findServices() throws Exception {
        DataStoreEntry entry = this.getSelfEntry();
        PodmanCommandView.Container view = this.commandView(((ShellStore)((PodmanCmdStore)this.getCmd().getStore()).getHost().getStore()).getOrStartSession());
        String out = view.port(this.containerName);
        return out.lines().map(l -> {
            Matcher matcher = Pattern.compile("(\\d+)/\\w+\\s*->\\s*[^:]+?:(\\d+)").matcher((CharSequence)l);
            if (!matcher.matches()) {
                return null;
            }
            int containerPort = Integer.parseInt(matcher.group(1));
            int remotePort = Integer.parseInt(matcher.group(2));
            return ((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)MappedServiceStore.builder().host(((PodmanCmdStore)this.getCmd().getStore()).getHost().asNeeded())).displayParent(entry.ref())).containerPort(containerPort).remotePort(Integer.valueOf(remotePort))).build();
        }).filter(dockerServiceStore -> dockerServiceStore != null).toList();
    }

    public Class<ContainerStoreState> getStateClass() {
        return ContainerStoreState.class;
    }

    public OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.containerName));
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.cmd);
        Validators.isType(this.cmd, PodmanCmdStore.class);
        this.cmd.checkComplete();
        Validators.nonNull((Object)this.containerName);
    }

    public ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public ShellControl control(ShellControl parent) throws Exception {
                PodmanContainerStore.this.refreshContainerState(((ShellStore)((PodmanCmdStore)PodmanContainerStore.this.getCmd().getStore()).getHost().getStore()).getOrStartSession());
                ShellControl pc = new PodmanCommandView(parent).container().exec(PodmanContainerStore.this.containerName);
                pc.withSourceStore((DataStore)PodmanContainerStore.this);
                pc.withShellStateInit((StatefulDataStore)PodmanContainerStore.this);
                pc.onStartupFail(throwable -> {
                    boolean hasShell;
                    if (throwable instanceof LicenseRequiredException) {
                        return;
                    }
                    boolean bl = hasShell = throwable.getMessage() == null || !throwable.getMessage().contains("OCI runtime exec failed");
                    if (!hasShell) {
                        ContainerStoreState.ContainerStoreStateBuilder stateBuilder = ((ContainerStoreState)PodmanContainerStore.this.getState()).toBuilder();
                        stateBuilder.shellMissing(Boolean.valueOf(true));
                        PodmanContainerStore.this.setState((DataStoreState)stateBuilder.build());
                    }
                });
                return pc;
            }

            public ShellStore getParentStore() {
                return (ShellStore)((PodmanCmdStore)PodmanContainerStore.this.getCmd().getStore()).getHost().getStore();
            }
        };
    }

    private void refreshContainerState(ShellControl sc) throws Exception {
        ContainerStoreState state = (ContainerStoreState)this.getState();
        PodmanCommandView.Container view = new PodmanCommandView(sc).container();
        String displayState = view.queryState(this.containerName);
        boolean running = displayState.startsWith("Up");
        ContainerStoreState newState = ((ContainerStoreState.ContainerStoreStateBuilder)state.toBuilder().containerState(displayState).running(Boolean.valueOf(running))).build();
        this.setState((DataStoreState)newState);
    }

    @Generated
    protected PodmanContainerStore(PodmanContainerStoreBuilder<?, ?> b) {
        this.cmd = b.cmd;
        this.containerName = b.containerName;
    }

    @Generated
    public static PodmanContainerStoreBuilder<?, ?> builder() {
        return new PodmanContainerStoreBuilderImpl();
    }

    @Generated
    public DataStoreEntryRef<PodmanCmdStore> getCmd() {
        return this.cmd;
    }

    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PodmanContainerStore)) {
            return false;
        }
        PodmanContainerStore other = (PodmanContainerStore)o;
        DataStoreEntryRef<PodmanCmdStore> this$cmd = this.getCmd();
        DataStoreEntryRef<PodmanCmdStore> other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        return !(this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<PodmanCmdStore> $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PodmanContainerStore(cmd=" + String.valueOf(this.getCmd()) + ", containerName=" + this.getContainerName() + ")";
    }

    @Generated
    public static abstract class PodmanContainerStoreBuilder<C extends PodmanContainerStore, B extends PodmanContainerStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<PodmanCmdStore> cmd;
        @Generated
        private String containerName;

        @Generated
        public B cmd(DataStoreEntryRef<PodmanCmdStore> cmd) {
            this.cmd = cmd;
            return this.self();
        }

        @Generated
        public B containerName(String containerName) {
            this.containerName = containerName;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PodmanContainerStore.PodmanContainerStoreBuilder(cmd=" + String.valueOf(this.cmd) + ", containerName=" + this.containerName + ")";
        }
    }

    @JsonTypeName(value="podman")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class PodmanContainerStoreBuilderImpl
    extends PodmanContainerStoreBuilder<PodmanContainerStore, PodmanContainerStoreBuilderImpl> {
        @Generated
        private PodmanContainerStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected PodmanContainerStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PodmanContainerStore build() {
            return new PodmanContainerStore(this);
        }
    }
}

