/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.lxd;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.BaseElevationHandler;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.system.lxd.LxdCmdStore;
import io.xpipe.ext.system.lxd.LxdCommandView;
import java.util.Objects;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="lxd")
@JsonDeserialize(builder=LxdContainerStoreBuilderImpl.class)
public final class LxdContainerStore
implements ShellStore,
FixedChildStore,
StatefulDataStore<ContainerStoreState>,
StartableStore,
StoppableStore,
PauseableStore,
NameableStore {
    private final DataStoreEntryRef<LxdCmdStore> cmd;
    private final String containerName;
    private final IdentityValue identity;

    public String getName() {
        return this.containerName;
    }

    public Class<ContainerStoreState> getStateClass() {
        return ContainerStoreState.class;
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.cmd);
        Validators.isType(this.cmd, LxdCmdStore.class);
        this.cmd.checkComplete();
        Validators.nonNull((Object)this.containerName);
        if (this.identity != null) {
            this.identity.checkComplete();
        }
    }

    public OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.containerName));
    }

    public FixedChildStore merge(FixedChildStore other) {
        LxdContainerStore o = (LxdContainerStore)other;
        return ((LxdContainerStoreBuilder)this.toBuilder().identity(this.identity != null ? this.identity : o.identity)).build();
    }

    public ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(){

            public ShellControl control(ShellControl parent) throws Exception {
                LxdContainerStore.this.refreshContainerState(((ShellStore)((LxdCmdStore)LxdContainerStore.this.getCmd().getStore()).getHost().getStore()).getOrStartSession());
                String user = LxdContainerStore.this.identity != null ? LxdContainerStore.this.identity.unwrap().getUsername().retrieveUsername() : null;
                ShellControl sc = new LxdCommandView(parent).exec(LxdContainerStore.this.containerName, user, () -> {
                    ContainerStoreState state = (ContainerStoreState)LxdContainerStore.this.getState();
                    boolean alpine = state.getOsName() != null && state.getOsName().toLowerCase().contains("alpine");
                    return alpine;
                });
                if (LxdContainerStore.this.identity != null && LxdContainerStore.this.identity.unwrap().getPassword() != null) {
                    sc.setElevationHandler(new BaseElevationHandler((DataStore)LxdContainerStore.this, LxdContainerStore.this.identity.unwrap().getPassword()).orElse(sc.getElevationHandler()));
                }
                sc.withSourceStore((DataStore)LxdContainerStore.this);
                sc.withShellStateInit((StatefulDataStore)LxdContainerStore.this);
                sc.onStartupFail(throwable -> {
                    if (throwable instanceof LicenseRequiredException) {
                        return;
                    }
                    ContainerStoreState s = ((ContainerStoreState.ContainerStoreStateBuilder)((ContainerStoreState)LxdContainerStore.this.getState()).toBuilder().running(Boolean.valueOf(false))).containerState("Connection failed").build();
                    LxdContainerStore.this.setState((DataStoreState)s);
                });
                return sc;
            }

            public ShellStore getParentStore() {
                return (ShellStore)((LxdCmdStore)LxdContainerStore.this.getCmd().getStore()).getHost().getStore();
            }
        };
    }

    private void refreshContainerState(ShellControl sc) throws Exception {
        ContainerStoreState state = (ContainerStoreState)this.getState();
        LxdCommandView view = new LxdCommandView(sc);
        String displayState = view.queryContainerState(this.containerName);
        boolean running = "RUNNING".equals(displayState);
        ContainerStoreState newState = ((ContainerStoreState.ContainerStoreStateBuilder)state.toBuilder().containerState(displayState).running(Boolean.valueOf(running))).build();
        this.setState((DataStoreState)newState);
    }

    public void start() throws Exception {
        ShellControl sc = ((ShellStore)((LxdCmdStore)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
        LxdCommandView view = new LxdCommandView(sc);
        view.start(this.containerName);
        this.refreshContainerState(sc);
    }

    public void stop() throws Exception {
        ShellControl sc = ((ShellStore)((LxdCmdStore)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
        LxdCommandView view = new LxdCommandView(sc);
        view.stop(this.containerName);
        this.refreshContainerState(sc);
    }

    public void pause() throws Exception {
        ShellControl sc = ((ShellStore)((LxdCmdStore)this.getCmd().getStore()).getHost().getStore()).getOrStartSession();
        LxdCommandView view = new LxdCommandView(sc);
        view.pause(this.containerName);
        this.refreshContainerState(sc);
    }

    @Generated
    protected LxdContainerStore(LxdContainerStoreBuilder<?, ?> b) {
        this.cmd = b.cmd;
        this.containerName = b.containerName;
        this.identity = b.identity;
    }

    @Generated
    public static LxdContainerStoreBuilder<?, ?> builder() {
        return new LxdContainerStoreBuilderImpl();
    }

    @Generated
    public LxdContainerStoreBuilder<?, ?> toBuilder() {
        return new LxdContainerStoreBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public DataStoreEntryRef<LxdCmdStore> getCmd() {
        return this.cmd;
    }

    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    @Generated
    public IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LxdContainerStore)) {
            return false;
        }
        LxdContainerStore other = (LxdContainerStore)o;
        DataStoreEntryRef<LxdCmdStore> this$cmd = this.getCmd();
        DataStoreEntryRef<LxdCmdStore> other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        IdentityValue this$identity = this.getIdentity();
        IdentityValue other$identity = other.getIdentity();
        return !(this$identity == null ? other$identity != null : !this$identity.equals(other$identity));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<LxdCmdStore> $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        IdentityValue $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LxdContainerStore(cmd=" + String.valueOf(this.getCmd()) + ", containerName=" + this.getContainerName() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public LxdContainerStore(DataStoreEntryRef<LxdCmdStore> cmd, String containerName, IdentityValue identity) {
        this.cmd = cmd;
        this.containerName = containerName;
        this.identity = identity;
    }

    @Generated
    public static abstract class LxdContainerStoreBuilder<C extends LxdContainerStore, B extends LxdContainerStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<LxdCmdStore> cmd;
        @Generated
        private String containerName;
        @Generated
        private IdentityValue identity;

        @Generated
        protected B $fillValuesFrom(C instance) {
            LxdContainerStoreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LxdContainerStore instance, LxdContainerStoreBuilder<?, ?> b) {
            b.cmd(instance.cmd);
            b.containerName(instance.containerName);
            b.identity(instance.identity);
        }

        @Generated
        public B cmd(DataStoreEntryRef<LxdCmdStore> cmd) {
            this.cmd = cmd;
            return this.self();
        }

        @Generated
        public B containerName(String containerName) {
            this.containerName = containerName;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identity) {
            this.identity = identity;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "LxdContainerStore.LxdContainerStoreBuilder(cmd=" + String.valueOf(this.cmd) + ", containerName=" + this.containerName + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="lxd")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class LxdContainerStoreBuilderImpl
    extends LxdContainerStoreBuilder<LxdContainerStore, LxdContainerStoreBuilderImpl> {
        @Generated
        private LxdContainerStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected LxdContainerStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LxdContainerStore build() {
            return new LxdContainerStore(this);
        }
    }
}

