/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.incus;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.CommandSupport;
import io.xpipe.app.util.FixedHierarchyStore;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.system.incus.IncusCommandView;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@JsonTypeName(value="incusInstall")
@JsonDeserialize(builder=IncusInstallStoreBuilderImpl.class)
public final class IncusInstallStore
implements FixedHierarchyStore,
StatefulDataStore<State>,
SelfReferentialStore {
    private final DataStoreEntryRef<ShellStore> host;

    public IncusInstallStore(DataStoreEntryRef<ShellStore> host) {
        this.host = host;
    }

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        this.host.checkComplete();
    }

    private void updateState() throws Exception {
        ShellControl sc = ((ShellStore)this.getHost().getStore()).getOrStartSession();
        IncusCommandView view = new IncusCommandView(sc);
        String out = view.version();
        Pattern namePattern = Pattern.compile("Server version:\\s+(.+)");
        Matcher nameMatcher = namePattern.matcher(out);
        String v = nameMatcher.find() ? nameMatcher.group(1) : null;
        boolean reachable = v != null && !"unreachable".equals(v);
        this.setState(((State.StateBuilder)((Object)((State.StateBuilder)((Object)((State)this.getState()).toBuilder().serverVersion(reachable ? v : null))).reachable(reachable))).build());
    }

    public List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() throws Exception {
        ShellControl sc = ((ShellStore)this.getHost().getStore()).getOrStartSession();
        IncusCommandView view = new IncusCommandView(sc);
        CommandSupport.isSupported(() -> view.isSupported(), (String)"Incus CLI client (incus)", (DataStoreEntry)this.host.get());
        this.updateState();
        return view.listContainers((DataStoreEntryRef<IncusInstallStore>)this.getSelfEntry().ref());
    }

    @Generated
    protected IncusInstallStore(IncusInstallStoreBuilder<?, ?> b) {
        this.host = b.host;
    }

    @Generated
    public static IncusInstallStoreBuilder<?, ?> builder() {
        return new IncusInstallStoreBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncusInstallStore)) {
            return false;
        }
        IncusInstallStore other = (IncusInstallStore)o;
        DataStoreEntryRef<ShellStore> this$host = this.getHost();
        DataStoreEntryRef<ShellStore> other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<ShellStore> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IncusInstallStore(host=" + String.valueOf(this.getHost()) + ")";
    }

    @Generated
    public DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @JsonDeserialize(builder=StateBuilderImpl.class)
    public static final class State
    extends DataStoreState {
        private final String serverVersion;
        private final boolean reachable;
        private final boolean showNonRunning;

        @Generated
        protected State(StateBuilder<?, ?> b) {
            super(b);
            this.serverVersion = b.serverVersion;
            this.reachable = b.reachable;
            this.showNonRunning = b.showNonRunning;
        }

        @Generated
        public static StateBuilder<?, ?> builder() {
            return new StateBuilderImpl();
        }

        @Generated
        public StateBuilder<?, ?> toBuilder() {
            return new StateBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getServerVersion() {
            return this.serverVersion;
        }

        @Generated
        public boolean isReachable() {
            return this.reachable;
        }

        @Generated
        public boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public String toString() {
            return "IncusInstallStore.State(serverVersion=" + this.getServerVersion() + ", reachable=" + this.isReachable() + ", showNonRunning=" + this.isShowNonRunning() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.isReachable() != other.isReachable()) {
                return false;
            }
            if (this.isShowNonRunning() != other.isShowNonRunning()) {
                return false;
            }
            String this$serverVersion = this.getServerVersion();
            String other$serverVersion = other.getServerVersion();
            return !(this$serverVersion == null ? other$serverVersion != null : !this$serverVersion.equals(other$serverVersion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isReachable() ? 79 : 97);
            result = result * 59 + (this.isShowNonRunning() ? 79 : 97);
            String $serverVersion = this.getServerVersion();
            result = result * 59 + ($serverVersion == null ? 43 : $serverVersion.hashCode());
            return result;
        }

        @Generated
        public static abstract class StateBuilder<C extends State, B extends StateBuilder<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String serverVersion;
            @Generated
            private boolean reachable;
            @Generated
            private boolean showNonRunning;

            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                StateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(State instance, StateBuilder<?, ?> b) {
                b.serverVersion(instance.serverVersion);
                b.reachable(instance.reachable);
                b.showNonRunning(instance.showNonRunning);
            }

            @Generated
            public B serverVersion(String serverVersion) {
                this.serverVersion = serverVersion;
                return (B)this.self();
            }

            @Generated
            public B reachable(boolean reachable) {
                this.reachable = reachable;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean showNonRunning) {
                this.showNonRunning = showNonRunning;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "IncusInstallStore.State.StateBuilder(super=" + super.toString() + ", serverVersion=" + this.serverVersion + ", reachable=" + this.reachable + ", showNonRunning=" + this.showNonRunning + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class StateBuilderImpl
        extends StateBuilder<State, StateBuilderImpl> {
            @Generated
            private StateBuilderImpl() {
            }

            @Override
            @Generated
            protected StateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public State build() {
                return new State(this);
            }
        }
    }

    @Generated
    public static abstract class IncusInstallStoreBuilder<C extends IncusInstallStore, B extends IncusInstallStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> host) {
            this.host = host;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IncusInstallStore.IncusInstallStoreBuilder(host=" + String.valueOf(this.host) + ")";
        }
    }

    @JsonTypeName(value="incusInstall")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class IncusInstallStoreBuilderImpl
    extends IncusInstallStoreBuilder<IncusInstallStore, IncusInstallStoreBuilderImpl> {
        @Generated
        private IncusInstallStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected IncusInstallStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IncusInstallStore build() {
            return new IncusInstallStore(this);
        }
    }
}

