/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.incus;

import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellOpenFunction;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.CommandViewBase;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.system.incus.IncusContainerStore;
import io.xpipe.ext.system.incus.IncusInstallStore;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;

public class IncusCommandView
extends CommandViewBase {
    public IncusCommandView(ShellControl shellControl) {
        super(shellControl);
    }

    private static ElevationFunction requiresElevation() {
        return new ElevationFunction(){

            public String getPrefix() {
                return "Incus";
            }

            public boolean isSpecified() {
                return true;
            }

            public boolean apply(ShellControl shellControl) throws Exception {
                return !shellControl.command("test -S /var/lib/incus/unix.socket && test -w /var/lib/incus/unix.socket || test -S /var/snap/incus/common/incus/unix.socket && test -w /var/snap/incus/common/incus/unix.socket || test -S /var/snap/incus/common/incus/unix.socket.user && test -w /var/snap/incus/common/incus/unix.socket.user || test -S /var/lib/incus/unix.socket.user && test -w /var/lib/incus/unix.socket.user").executeAndCheck();
            }
        };
    }

    private static String formatErrorMessage(String s) {
        return s;
    }

    private static <T extends Throwable> T convertException(T s) {
        return (T)ErrorEventFactory.expectedIfContains(s, (String[])new String[0]);
    }

    protected CommandControl build(Consumer<CommandBuilder> builder) {
        CommandBuilder cmd = CommandBuilder.of().add(new String[]{"incus"});
        builder.accept(cmd);
        return this.shellControl.command(cmd).withErrorFormatter(IncusCommandView::formatErrorMessage).withExceptionConverter(IncusCommandView::convertException).elevated(IncusCommandView.requiresElevation());
    }

    public IncusCommandView start() throws Exception {
        this.shellControl.start();
        return this;
    }

    public boolean isSupported() throws Exception {
        return this.shellControl.command("incus --help").withErrorFormatter(IncusCommandView::formatErrorMessage).withExceptionConverter(IncusCommandView::convertException).executeAndCheck();
    }

    public String version() throws Exception {
        return this.build(commandBuilder -> commandBuilder.add(new String[]{"version"})).readStdoutOrThrow();
    }

    public void start(String containerName) throws Exception {
        this.build(commandBuilder -> commandBuilder.add(new String[]{"start"}).addQuoted(containerName)).execute();
    }

    public void stop(String containerName) throws Exception {
        this.build(commandBuilder -> commandBuilder.add(new String[]{"stop"}).addQuoted(containerName)).execute();
    }

    public void pause(String containerName) throws Exception {
        this.build(commandBuilder -> commandBuilder.add(new String[]{"pause"}).addQuoted(containerName)).execute();
    }

    public CommandControl console(String containerName) {
        return this.build(commandBuilder -> commandBuilder.add(new String[]{"console"}).addQuoted(containerName));
    }

    public CommandControl configEdit(String containerName) {
        return this.build(commandBuilder -> commandBuilder.add(new String[]{"config", "edit"}).addQuoted(containerName));
    }

    public List<DataStoreEntryRef<IncusContainerStore>> listContainers(DataStoreEntryRef<IncusInstallStore> store) throws Exception {
        return this.listContainersAndStates().entrySet().stream().map(s -> {
            boolean running = ((String)s.getValue()).toLowerCase(Locale.ROOT).equals("running");
            IncusContainerStore c = new IncusContainerStore(store, (String)s.getKey(), IdentityValue.ofBreakout((DataStoreEntry)store.get()));
            DataStoreEntry entry = DataStoreEntry.createNew((String)c.getContainerName(), (DataStore)c);
            entry.setStorePersistentState((DataStoreState)((ContainerStoreState.ContainerStoreStateBuilder)ContainerStoreState.builder().containerState((String)s.getValue()).running(Boolean.valueOf(running))).build());
            return Optional.of(entry.ref());
        }).flatMap(Optional::stream).toList();
    }

    public String queryContainerState(String containerName) throws Exception {
        Map<String, String> states = this.listContainersAndStates();
        return states.getOrDefault(containerName, "?");
    }

    private Map<String, String> listContainersAndStates() throws Exception {
        try (CommandControl c = this.build(commandBuilder -> commandBuilder.add(new String[]{"list", "-f", "csv", "-c", "ns"})).start();){
            String output = c.readStdoutOrThrow();
            Map map = output.lines().collect(Collectors.toMap(s -> s.strip().split(",")[0], s -> s.strip().split(",")[1], (x, y) -> y, LinkedHashMap::new));
            return map;
        }
    }

    public ShellControl exec(String container, String user, Supplier<Boolean> busybox) {
        ShellControl sub = this.shellControl.subShell();
        sub.setDumbOpen(this.createOpenFunction(container, user, false, busybox));
        sub.setTerminalOpen(this.createOpenFunction(container, user, true, busybox));
        return sub.withExceptionConverter(IncusCommandView::convertException).elevated(IncusCommandView.requiresElevation());
    }

    private ShellOpenFunction createOpenFunction(final String containerName, final String user, final boolean terminal, final Supplier<Boolean> busybox) {
        return new ShellOpenFunction(){
            final /* synthetic */ IncusCommandView this$0;
            {
                this.this$0 = this$0;
            }

            public CommandBuilder prepareWithoutInitCommand() {
                CommandBuilder b = this.this$0.execCommand(containerName, terminal).add(new String[]{"su", "-l"});
                if (user != null) {
                    b.addQuoted(user);
                }
                return b;
            }

            public CommandBuilder prepareWithInitCommand(@NonNull String command) {
                if (command == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                CommandBuilder b = this.this$0.execCommand(containerName, terminal).add(new String[]{"su", "-l"});
                if (user != null) {
                    b.addQuoted(user);
                }
                return b.add(arg_0 -> 2.lambda$prepareWithInitCommand$0((Supplier)busybox, arg_0)).addLiteral(command);
            }

            private static /* synthetic */ String lambda$prepareWithInitCommand$0(Supplier busybox2, ShellControl sc) throws Exception {
                Boolean suType = (Boolean)busybox2.get();
                if (suType.booleanValue()) {
                    return "-c";
                }
                return "--session-command";
            }
        };
    }

    public CommandBuilder execCommand(String containerName, boolean terminal) {
        CommandBuilder c = CommandBuilder.of().add(new String[]{"incus", "exec", terminal ? "-t" : "-T"});
        return c.addQuoted(containerName).add(new String[]{"--"});
    }
}

